/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.startup;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StartupStep;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.spi.StartupCondition;
import org.apache.camel.spi.StartupConditionStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeferredContextBinding
public class DefaultStartupConditionStrategy
extends ServiceSupport
implements StartupConditionStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStartupConditionStrategy.class);
    private CamelContext camelContext;
    private final List<StartupCondition> conditions = new ArrayList<StartupCondition>();
    private String classNames;
    private boolean enabled;
    private int interval = 500;
    private int timeout = 20000;
    private String onTimeout = "stop";
    private volatile boolean checkDone;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getOnTimeout() {
        return this.onTimeout;
    }

    public void setOnTimeout(String onTimeout) {
        this.onTimeout = onTimeout;
    }

    public void addStartupCondition(StartupCondition startupCondition) {
        this.conditions.add(startupCondition);
    }

    public void addStartupConditions(String classNames) {
        this.classNames = classNames;
    }

    public List<StartupCondition> getStartupConditions() {
        return this.conditions;
    }

    public void checkStartupConditions() throws VetoCamelContextStartException {
        if (!this.checkDone && this.enabled) {
            try {
                ArrayList<StartupCondition> list = new ArrayList<StartupCondition>(this.conditions);
                list.addAll(this.camelContext.getRegistry().findByType(StartupCondition.class));
                if (this.classNames != null) {
                    for (String fqn : this.classNames.split(",")) {
                        fqn = fqn.trim();
                        Class clazz = this.camelContext.getClassResolver().resolveMandatoryClass(fqn, StartupCondition.class);
                        list.add((StartupCondition)this.camelContext.getInjector().newInstance(clazz));
                    }
                }
                list.sort(OrderedComparator.get());
                if (!list.isEmpty()) {
                    StartupStepRecorder recorder = this.camelContext.getCamelContextExtension().getStartupStepRecorder();
                    StartupStep step = recorder.beginStep(CamelContext.class, this.camelContext.getCamelContextExtension().getName(), "Check Startup Conditions");
                    this.doCheckConditions(list);
                    recorder.endStep(step);
                }
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            finally {
                this.checkDone = true;
            }
        }
    }

    protected void doCheckConditions(List<StartupCondition> conditions) throws VetoCamelContextStartException {
        String msg;
        StopWatch watch = new StopWatch();
        boolean first = true;
        int tick = 1;
        int counter = 1;
        while (watch.taken() < (long)this.timeout) {
            boolean ok = true;
            for (StartupCondition startup : conditions) {
                if (this.isCamelStopping()) {
                    return;
                }
                if (first && (msg = startup.getWaitMessage()) != null) {
                    LOG.info(msg);
                }
                if (!ok) continue;
                try {
                    LOG.trace("canContinue attempt #{}: {}", (Object)counter, (Object)startup.getName());
                    ok = startup.canContinue(this.camelContext);
                    LOG.debug("canContinue attempt #{}: {} -> {}", new Object[]{counter, startup.getName(), ok});
                }
                catch (Exception e) {
                    throw new VetoCamelContextStartException("Startup condition " + startup.getName() + " failed due to: " + e.getMessage(), (Throwable)e, this.camelContext);
                }
            }
            first = false;
            if (ok) {
                return;
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sleep interrupted, are we stopping? {}", (Object)this.isCamelStopping());
                }
                Thread.currentThread().interrupt();
                throw new VetoCamelContextStartException("Sleep interrupted", (Throwable)e, this.camelContext, false);
            }
            long seconds = watch.taken() / 1000L;
            if (seconds > (long)tick && ++tick % 2 == 0) {
                LOG.info("Waited {} for startup conditions to continue...", (Object)TimeUtils.printDuration((long)watch.taken()));
            }
            ++counter;
        }
        Object error = "Startup condition timeout error";
        for (StartupCondition startup : conditions) {
            msg = startup.getFailureMessage();
            if (msg == null) continue;
            error = "Startup condition: " + startup.getName() + " cannot continue due to: " + msg;
        }
        if ("fail".equalsIgnoreCase(this.onTimeout)) {
            throw new VetoCamelContextStartException((String)error, this.camelContext, true);
        }
        if ("stop".equalsIgnoreCase(this.onTimeout)) {
            throw new VetoCamelContextStartException((String)error, this.camelContext, false);
        }
        LOG.warn((String)error);
        LOG.warn("Camel will continue to startup");
    }

    private boolean isCamelStopping() {
        return this.camelContext.isStopping();
    }
}

