# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE OVERWRITTEN!
#
# IF YOU WANT TO MODIFY THIS FILE, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `dev/breeze/src/airflow_breeze/templates` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-apache-spark",
        "name": "Apache Spark",
        "description": "`Apache Spark <https://spark.apache.org/>`__\n",
        "integrations": [
            {
                "integration-name": "Apache Spark",
                "external-doc-url": "https://spark.apache.org/",
                "how-to-guide": ["/docs/apache-airflow-providers-apache-spark/operators.rst"],
                "logo": "/docs/integration-logos/spark.png",
                "tags": ["apache"],
            }
        ],
        "operators": [
            {
                "integration-name": "Apache Spark",
                "python-modules": [
                    "airflow.providers.apache.spark.operators.spark_jdbc",
                    "airflow.providers.apache.spark.operators.spark_sql",
                    "airflow.providers.apache.spark.operators.spark_submit",
                    "airflow.providers.apache.spark.operators.spark_pyspark",
                ],
            }
        ],
        "hooks": [
            {
                "integration-name": "Apache Spark",
                "python-modules": [
                    "airflow.providers.apache.spark.hooks.spark_connect",
                    "airflow.providers.apache.spark.hooks.spark_jdbc",
                    "airflow.providers.apache.spark.hooks.spark_jdbc_script",
                    "airflow.providers.apache.spark.hooks.spark_sql",
                    "airflow.providers.apache.spark.hooks.spark_submit",
                ],
            }
        ],
        "connection-types": [
            {
                "hook-class-name": "airflow.providers.apache.spark.hooks.spark_connect.SparkConnectHook",
                "connection-type": "spark_connect",
            },
            {
                "hook-class-name": "airflow.providers.apache.spark.hooks.spark_jdbc.SparkJDBCHook",
                "connection-type": "spark_jdbc",
            },
            {
                "hook-class-name": "airflow.providers.apache.spark.hooks.spark_sql.SparkSqlHook",
                "connection-type": "spark_sql",
            },
            {
                "hook-class-name": "airflow.providers.apache.spark.hooks.spark_submit.SparkSubmitHook",
                "connection-type": "spark",
            },
        ],
        "task-decorators": [
            {
                "class-name": "airflow.providers.apache.spark.decorators.pyspark.pyspark_task",
                "name": "pyspark",
            }
        ],
    }
