/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.dotnet;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Environment;

public class DotNetExecTask
extends ExecTask {
    private static final String MS_VM = "microsoft";
    private String executable;
    private String vm = Os.isFamily((String)"windows") ? "microsoft" : "mono";
    private String errorProperty;

    public void setExecutable(String value) {
        this.executable = value;
    }

    public void setVm(String value) {
        this.vm = value;
    }

    public void internalSetErrorProperty(String name) {
        this.errorProperty = name;
    }

    public void execute() throws BuildException {
        if (this.executable == null) {
            throw new BuildException("The executable attribute is required");
        }
        this.setupCommandline();
        super.execute();
    }

    protected void maybeSetResultPropertyValue(int result) {
        if (this.errorProperty != null && Execute.isFailure((int)result)) {
            this.getProject().setNewProperty(this.errorProperty, String.valueOf(true));
        }
        super.maybeSetResultPropertyValue(result);
    }

    protected void setupCommandline() {
        if (this.cmdl.getExecutable() == null) {
            if (this.vm.equals(MS_VM)) {
                super.setExecutable(this.executable);
            } else {
                boolean b = this.getResolveExecutable();
                this.setResolveExecutable(b || DotNetExecTask.isMono(this.vm));
                super.setExecutable(this.vm);
                this.cmdl.createArgument(true).setValue(this.resolveExecutable(this.executable, DotNetExecTask.isMono(this.vm)));
                this.setResolveExecutable(b);
            }
        }
    }

    protected static final boolean isMono(String vm) {
        return "mono".equals(vm) || "mint".equals(vm);
    }

    public static DotNetExecTask getTask(Task t, String vm, String executable, Environment env) {
        String[] environment;
        DotNetExecTask exec = new DotNetExecTask();
        if (vm != null) {
            exec.setVm(vm);
        }
        exec.setProject(t.getProject());
        exec.setExecutable(executable);
        exec.setTaskName(t.getTaskName());
        if (env != null && (environment = env.getVariables()) != null) {
            for (int i = 0; i < environment.length; ++i) {
                int idx = environment[i].indexOf("=");
                Environment.Variable v = new Environment.Variable();
                v.setKey(environment[i].substring(0, idx));
                v.setValue(environment[i].substring(idx + 1));
                exec.addEnv(v);
            }
        }
        return exec;
    }
}

