/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.asterix.fuzzyjoin.LittleEndianIntInputStream;
import org.apache.asterix.fuzzyjoin.ResultJoin;
import org.apache.asterix.fuzzyjoin.ResultSelfJoin;
import org.apache.asterix.fuzzyjoin.invertedlist.InvertedListLengthList;
import org.apache.asterix.fuzzyjoin.invertedlist.InvertedListsLengthList;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFiltersJaccard;

public class FuzzyJoinMemory {
    private final InvertedListsLengthList invertedLists = new InvertedListsLengthList();
    private final SimilarityFiltersJaccard similarityFilters;
    private final ArrayList<int[]> records;

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: <threshold> <file> [no runs, e.g., 1] [warm-up factor, e.g., 1]");
            System.exit(2);
        }
        float similarityThreshold = Float.parseFloat(args[0]);
        String fileName = args[1];
        int noRuns = 1;
        int warmUpFactor = 1;
        if (args.length > 2) {
            noRuns = Integer.valueOf(args[2]);
            if (args.length > 3) {
                warmUpFactor = Integer.valueOf(args[3]);
            }
        }
        System.err.println("Document: " + fileName);
        System.err.println("... LOADING DATASET ...");
        ArrayList<int[]> records = new ArrayList<int[]>();
        ArrayList<Integer> rids = new ArrayList<Integer>();
        FuzzyJoinMemory fj = new FuzzyJoinMemory(similarityThreshold);
        FuzzyJoinMemory.readRecords(fileName, records, rids);
        System.err.println("Algorithm: ppjoin");
        System.err.println("Threshold: Jaccard " + similarityThreshold);
        List<ResultSelfJoin> results = fj.runs(records, noRuns, warmUpFactor);
        for (ResultSelfJoin result : results) {
            System.out.format("%d %d %.3f", rids.get(result.indexX), rids.get(result.indexY), Float.valueOf(result.similarity));
            System.out.println();
        }
    }

    public static void readRecords(String fileName, List<int[]> records, List<Integer> rids) throws IOException {
        try (LittleEndianIntInputStream in = new LittleEndianIntInputStream(new BufferedInputStream(new FileInputStream(fileName)));){
            while (true) {
                int rid = 0;
                try {
                    rid = in.readInt();
                }
                catch (IOException e) {
                    break;
                }
                rids.add(rid);
                int size = in.readInt();
                int[] record = new int[size];
                for (int j = 0; j < size; ++j) {
                    int token;
                    record[j] = token = in.readInt();
                }
                records.add(record);
            }
        }
    }

    public FuzzyJoinMemory(float similarityThreshold) {
        this.similarityFilters = new SimilarityFiltersJaccard(similarityThreshold);
        this.records = new ArrayList();
    }

    public void add(int[] tokens) {
        int index = this.records.size();
        int length = tokens.length;
        int indexPrefixLength = this.similarityFilters.getPrefixLength(length);
        for (int indexToken = 0; indexToken < indexPrefixLength; ++indexToken) {
            this.invertedLists.index(tokens[indexToken], new int[]{index, indexToken, length});
        }
        this.records.add(tokens);
    }

    public ArrayList<ResultJoin> join(int[] tokens, int length) {
        int prefixLength = this.similarityFilters.getPrefixLength(length);
        int lengthLowerBound = this.similarityFilters.getLengthLowerBound(length);
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        for (int indexToken = 0; indexToken < Math.min(prefixLength, tokens.length); ++indexToken) {
            int token = tokens[indexToken];
            InvertedListLengthList invertedList = this.invertedLists.get(token);
            if (invertedList == null) continue;
            invertedList.setMinLength(lengthLowerBound);
            for (int[] element : invertedList) {
                int indexProbe = element[0];
                int indexTokenProbe = element[1];
                int lengthProbe = element[2];
                Integer count = (Integer)counts.get(indexProbe);
                if (count == null) {
                    count = 0;
                }
                if (count == -1) continue;
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                if (!this.similarityFilters.passPositionFilter(count, indexToken, length, indexTokenProbe, lengthProbe)) {
                    count = -1;
                }
                if (count == 1 && !this.similarityFilters.passSuffixFilter(tokens, indexToken, this.records.get(indexProbe), indexTokenProbe)) {
                    count = -1;
                }
                counts.put(indexProbe, count);
            }
        }
        ArrayList<ResultJoin> results = new ArrayList<ResultJoin>();
        counts.forEach((key, value) -> {
            int[] tokensProbe;
            float similarity;
            int count = value;
            int indexProbe = key;
            if (count > 0 && (similarity = this.similarityFilters.passSimilarityFilter(tokens, prefixLength, tokensProbe = this.records.get(indexProbe), this.similarityFilters.getPrefixLength(tokensProbe.length), count)) > 0.0f) {
                results.add(new ResultJoin(indexProbe, similarity));
            }
        });
        return results;
    }

    public void prune(int length) {
        int lengthLowerBound = this.similarityFilters.getLengthLowerBound(length + 1);
        this.invertedLists.prune(lengthLowerBound);
    }

    public List<ResultSelfJoin> runs(Collection<int[]> records, int noRuns, int warmupFactor) {
        if (records.size() < 2) {
            return new ArrayList<ResultSelfJoin>();
        }
        int noRunsTotal = noRuns * warmupFactor;
        float runtime = 0.0f;
        float runtimeAverage = 0.0f;
        ArrayList<ResultSelfJoin> results = new ArrayList<ResultSelfJoin>();
        System.err.println("# Records: " + records.size());
        System.err.print("=== BEGIN JOIN (TIMER STARTED) === ");
        for (int i = 1; i <= noRunsTotal; ++i) {
            System.err.print(".");
            System.err.flush();
            results.clear();
            Runtime.getRuntime().gc();
            Date startTime = new Date();
            for (int[] record : records) {
                results.addAll(this.selfJoinAndAddRecord(record));
            }
            Date endTime = new Date();
            runtime = (float)(endTime.getTime() - startTime.getTime()) / 1000.0f;
            if (i < noRunsTotal - noRuns) continue;
            runtimeAverage += runtime;
        }
        System.err.println();
        System.err.println("# Results: " + results.size());
        System.err.println("=== END JOIN (TIMER STOPPED) ===");
        System.err.println("Total Running Time:  " + runtimeAverage / (float)noRuns + " (" + runtime + ")");
        System.err.println();
        return results;
    }

    public ArrayList<ResultSelfJoin> selfJoinAndAddRecord(int[] tokens) {
        int index = this.records.size();
        int length = tokens.length;
        int prefixLength = this.similarityFilters.getPrefixLength(length);
        int indexPrefixLength = this.similarityFilters.getIndexPrefixLength(length);
        int lengthLowerBound = this.similarityFilters.getLengthLowerBound(length);
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        for (int indexToken = 0; indexToken < prefixLength; ++indexToken) {
            int token = tokens[indexToken];
            InvertedListLengthList invertedList = this.invertedLists.get(token);
            if (invertedList != null) {
                invertedList.setMinLength(lengthLowerBound);
                for (int[] element : invertedList) {
                    int indexProbe = element[0];
                    int indexTokenProbe = element[1];
                    int lengthProbe = element[2];
                    Integer count = (Integer)counts.get(indexProbe);
                    if (count == null) {
                        count = 0;
                    }
                    if (count == -1) continue;
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    if (!this.similarityFilters.passPositionFilter(count, indexToken, length, indexTokenProbe, lengthProbe)) {
                        count = -1;
                    }
                    if (count == 1 && !this.similarityFilters.passSuffixFilter(tokens, indexToken, this.records.get(indexProbe), indexTokenProbe)) {
                        count = -1;
                    }
                    counts.put(indexProbe, count);
                }
            }
            if (indexToken >= indexPrefixLength) continue;
            this.invertedLists.index(token, new int[]{index, indexToken, length});
        }
        this.records.add(tokens);
        ArrayList<ResultSelfJoin> results = new ArrayList<ResultSelfJoin>();
        counts.forEach((key, value) -> {
            int[] tokensProbe;
            float similarity;
            int count = value;
            int indexProbe = key;
            if (count > 0 && (similarity = this.similarityFilters.passSimilarityFilter(tokens, prefixLength, tokensProbe = this.records.get(indexProbe), this.similarityFilters.getIndexPrefixLength(tokensProbe.length), count)) > 0.0f) {
                results.add(new ResultSelfJoin(index, indexProbe, similarity));
            }
        });
        return results;
    }
}

