/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin;

import java.util.regex.Pattern;

public class FuzzyJoinUtil {
    private static final Pattern rePunctuation = Pattern.compile("[^\\p{L}\\p{N}]");
    private static final Pattern reSpaceOrAnderscore = Pattern.compile("(_|\\s)+");

    public static String clean(String in) {
        in = rePunctuation.matcher(in).replaceAll(" ");
        in = reSpaceOrAnderscore.matcher(in).replaceAll(" ");
        in = in.trim();
        in = in.replace(' ', '_');
        in = in.toLowerCase();
        return in;
    }

    public static String getData(Object[] splits, int[] dataColumns, char tokenSeparator) {
        String data = null;
        for (int dataColumn : dataColumns) {
            if (data != null) {
                data = data + tokenSeparator;
            }
            if (splits.length <= dataColumn) continue;
            if (data == null) {
                data = "";
            }
            data = data + FuzzyJoinUtil.clean(splits[dataColumn].toString());
        }
        return data;
    }

    public static int[] getDataColumns(String columnsString) {
        String[] splits = columnsString.split(",");
        int[] columns = new int[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            columns[i] = Integer.parseInt(splits[i]);
        }
        return columns;
    }
}

