/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.Collection;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.shutdown.ShutdownRun;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterShutdownWork
extends SynchronizableWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final boolean terminateNCService;
    private final IResultCallback<Boolean> callback;

    public ClusterShutdownWork(ClusterControllerService ncs, boolean terminateNCService, IResultCallback<Boolean> callback) {
        this.ccs = ncs;
        this.terminateNCService = terminateNCService;
        this.callback = callback;
    }

    public void doRun() {
        try {
            if (this.ccs.getShutdownRun() != null) {
                throw new IPCException("Shutdown already in progress");
            }
            INodeManager nodeManager = this.ccs.getNodeManager();
            Collection<String> nodeIds = nodeManager.getAllNodeIds();
            ShutdownRun shutdownStatus = new ShutdownRun(nodeIds);
            this.ccs.setShutdownRun(shutdownStatus);
            nodeManager.apply(this::shutdownNode);
            Thread finalWork = new Thread(() -> {
                try {
                    LOGGER.info("Waiting for NCs to shutdown...");
                    boolean cleanShutdown = shutdownStatus.waitForCompletion();
                    if (!cleanShutdown) {
                        LOGGER.error("Clean shutdown of NCs timed out- giving up; unresponsive nodes: " + shutdownStatus.getRemainingNodes());
                    }
                    this.callback.setValue((Object)cleanShutdown);
                    this.ccs.stop(this.terminateNCService);
                    ExitUtil.exit((int)(cleanShutdown ? 0 : 1));
                }
                catch (Exception e) {
                    this.callback.setException(e);
                }
                finally {
                    shutdownStatus.notifyCcStopComplete();
                }
            }, ((Object)((Object)this)).getClass().getSimpleName() + "-Helper");
            finalWork.start();
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }

    protected void shutdownNode(String nodeId, NodeControllerState ncState) {
        try {
            LOGGER.info("Notifying NC " + nodeId + " to shutdown...");
            ncState.getNodeController().shutdown(this.terminateNCService);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception shutting down NC " + nodeId + " (possibly dead?), continuing shutdown...", (Throwable)e);
        }
    }
}

