/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractExpression;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class SelectExpression
extends AbstractExpression {
    private List<LetClause> letList = new ArrayList<LetClause>();
    private SelectSetOperation selectSetOperation;
    private OrderbyClause orderbyClause;
    private LimitClause limitClause;
    private boolean subquery;

    public SelectExpression(List<LetClause> letList, SelectSetOperation selectSetOperation, OrderbyClause orderbyClause, LimitClause limitClause, boolean subquery) {
        if (letList != null) {
            this.letList.addAll(letList);
        }
        this.selectSetOperation = selectSetOperation;
        this.orderbyClause = orderbyClause;
        this.limitClause = limitClause;
        this.subquery = subquery;
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Expression.Kind getKind() {
        return Expression.Kind.SELECT_EXPRESSION;
    }

    public List<LetClause> getLetList() {
        return this.letList;
    }

    public SelectSetOperation getSelectSetOperation() {
        return this.selectSetOperation;
    }

    public OrderbyClause getOrderbyClause() {
        return this.orderbyClause;
    }

    public LimitClause getLimitClause() {
        return this.limitClause;
    }

    public boolean hasOrderby() {
        return this.orderbyClause != null;
    }

    public boolean hasLimit() {
        return this.limitClause != null;
    }

    public boolean hasLetClauses() {
        return this.letList != null && !this.letList.isEmpty();
    }

    public boolean isSubquery() {
        return this.subquery;
    }

    public void setSubquery(boolean setSubquery) {
        this.subquery = setSubquery;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.letList, this.limitClause, this.orderbyClause, this.selectSetOperation, this.subquery});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SelectExpression)) {
            return false;
        }
        SelectExpression target = (SelectExpression)((Object)object);
        return Objects.equals(this.letList, target.letList) && Objects.equals(this.limitClause, target.limitClause) && Objects.equals(this.orderbyClause, target.orderbyClause) && this.subquery == target.subquery && Objects.equals((Object)this.selectSetOperation, (Object)target.selectSetOperation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subquery ? "(" : "");
        if (this.hasLetClauses()) {
            sb.append(this.letList.toString());
        }
        sb.append((Object)this.selectSetOperation);
        if (this.hasOrderby()) {
            sb.append(this.orderbyClause);
        }
        if (this.hasLimit()) {
            sb.append(this.limitClause);
        }
        sb.append(this.subquery ? ")" : "");
        return sb.toString();
    }
}

