/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ConsolidateSelectsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        SelectOperator firstSelect = (SelectOperator)op;
        IFunctionInfo andFn = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.AND);
        ScalarFunctionCallExpression conj = null;
        SelectOperator topMostOp = null;
        SelectOperator selectParent = null;
        SelectOperator nextSelect = firstSelect;
        while (true) {
            if ((nextSelect = (AbstractLogicalOperator)((Mutable)(selectParent = nextSelect).getInputs().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.ASSIGN && OperatorPropertiesUtil.isMovable((ILogicalOperator)nextSelect)) {
                continue;
            }
            if (nextSelect.getOperatorTag() != LogicalOperatorTag.SELECT) break;
            topMostOp = selectParent;
            if (conj == null) {
                conj = new ScalarFunctionCallExpression(andFn);
                conj.setSourceLocation(firstSelect.getSourceLocation());
                conj.getArguments().add(new MutableObject(firstSelect.getCondition().getValue()));
            }
            do {
                conj.getArguments().add(nextSelect.getCondition());
                selectParent = nextSelect;
            } while ((nextSelect = (AbstractLogicalOperator)((Mutable)nextSelect.getInputs().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.SELECT);
            if (topMostOp.getOperatorTag() == LogicalOperatorTag.ASSIGN || topMostOp == firstSelect) {
                topMostOp.getInputs().set(0, selectParent.getInputs().get(0));
            }
            nextSelect = selectParent;
        }
        if (conj == null) {
            return false;
        }
        firstSelect.getCondition().setValue(conj);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)firstSelect);
        return true;
    }
}

