/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILockManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.transaction.management.service.locking.DumpTablePrinter;
import org.apache.asterix.transaction.management.service.locking.JobArenaManager;
import org.apache.asterix.transaction.management.service.locking.LockManagerStats;
import org.apache.asterix.transaction.management.service.locking.RecordManagerStats;
import org.apache.asterix.transaction.management.service.locking.RequestArenaManager;
import org.apache.asterix.transaction.management.service.locking.ResourceArenaManager;
import org.apache.asterix.transaction.management.service.locking.ResourceGroup;
import org.apache.asterix.transaction.management.service.locking.ResourceGroupTable;
import org.apache.asterix.transaction.management.service.locking.ResourceTablePrinter;
import org.apache.asterix.transaction.management.service.locking.TablePrinter;
import org.apache.asterix.transaction.management.service.locking.TypeUtil;
import org.apache.asterix.transaction.management.service.transaction.TransactionManagementConstants;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConcurrentLockManager
implements ILockManager,
ILifeCycleComponent {
    static final Logger LOGGER = LogManager.getLogger();
    static final Level LVL = Level.TRACE;
    private static final boolean ENABLED_DEADLOCK_FREE_LOCKING_PROTOCOL = true;
    private static final int NIL = -1;
    private static final long NILL = -1L;
    private static final boolean DEBUG_MODE = false;
    private static final boolean CHECK_CONSISTENCY = false;
    private final ResourceGroupTable table;
    private final ResourceArenaManager resArenaMgr;
    private final RequestArenaManager reqArenaMgr;
    private final JobArenaManager jobArenaMgr;
    private final Long2LongMap txnId2TxnSlotMap;
    private final LockManagerStats stats = new LockManagerStats(10000);
    private static final LockAction[][] ACTION_MATRIX = new LockAction[][]{{LockAction.ERR, LockAction.UPD, LockAction.UPD, LockAction.UPD, LockAction.UPD}, {LockAction.ERR, LockAction.GET, LockAction.UPD, LockAction.UPD, LockAction.WAIT}, {LockAction.ERR, LockAction.GET, LockAction.GET, LockAction.WAIT, LockAction.WAIT}, {LockAction.ERR, LockAction.GET, LockAction.WAIT, LockAction.GET, LockAction.WAIT}, {LockAction.ERR, LockAction.WAIT, LockAction.WAIT, LockAction.WAIT, LockAction.WAIT}};
    private final Queue waiter = new Queue(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long request, long resource, long job) {
            long waiter = ConcurrentLockManager.this.resArenaMgr.getFirstWaiter(resource);
            ConcurrentLockManager.this.reqArenaMgr.setNextRequest(request, -1L);
            if (waiter == -1L) {
                ConcurrentLockManager.this.resArenaMgr.setFirstWaiter(resource, request);
            } else {
                ConcurrentLockManager.this.appendToRequestQueue(waiter, request);
            }
            JobArenaManager jobArenaManager = ConcurrentLockManager.this.jobArenaMgr;
            synchronized (jobArenaManager) {
                waiter = ConcurrentLockManager.this.jobArenaMgr.getLastWaiter(job);
                ConcurrentLockManager.this.insertIntoJobQueue(request, waiter);
                ConcurrentLockManager.this.jobArenaMgr.setLastWaiter(job, request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(long request, long resource, long job) {
            long waiter = ConcurrentLockManager.this.resArenaMgr.getFirstWaiter(resource);
            if (waiter == request) {
                long next = ConcurrentLockManager.this.reqArenaMgr.getNextRequest(waiter);
                ConcurrentLockManager.this.resArenaMgr.setFirstWaiter(resource, next);
            } else {
                waiter = ConcurrentLockManager.this.removeRequestFromQueueForSlot(waiter, request);
            }
            JobArenaManager jobArenaManager = ConcurrentLockManager.this.jobArenaMgr;
            synchronized (jobArenaManager) {
                long newHead = ConcurrentLockManager.this.removeRequestFromJob(waiter, ConcurrentLockManager.this.jobArenaMgr.getLastWaiter(job));
                ConcurrentLockManager.this.jobArenaMgr.setLastWaiter(job, newHead);
            }
        }
    };
    private final Queue upgrader = new Queue(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long request, long resource, long job) {
            long upgrader = ConcurrentLockManager.this.resArenaMgr.getFirstUpgrader(resource);
            ConcurrentLockManager.this.reqArenaMgr.setNextRequest(request, -1L);
            if (upgrader == -1L) {
                ConcurrentLockManager.this.resArenaMgr.setFirstUpgrader(resource, request);
            } else {
                ConcurrentLockManager.this.appendToRequestQueue(upgrader, request);
            }
            JobArenaManager jobArenaManager = ConcurrentLockManager.this.jobArenaMgr;
            synchronized (jobArenaManager) {
                upgrader = ConcurrentLockManager.this.jobArenaMgr.getLastUpgrader(job);
                ConcurrentLockManager.this.insertIntoJobQueue(request, upgrader);
                ConcurrentLockManager.this.jobArenaMgr.setLastUpgrader(job, request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(long request, long resource, long job) {
            long upgrader = ConcurrentLockManager.this.resArenaMgr.getFirstUpgrader(resource);
            if (upgrader == request) {
                long next = ConcurrentLockManager.this.reqArenaMgr.getNextRequest(upgrader);
                ConcurrentLockManager.this.resArenaMgr.setFirstUpgrader(resource, next);
            } else {
                upgrader = ConcurrentLockManager.this.removeRequestFromQueueForSlot(upgrader, request);
            }
            JobArenaManager jobArenaManager = ConcurrentLockManager.this.jobArenaMgr;
            synchronized (jobArenaManager) {
                long newHead = ConcurrentLockManager.this.removeRequestFromJob(upgrader, ConcurrentLockManager.this.jobArenaMgr.getLastUpgrader(job));
                ConcurrentLockManager.this.jobArenaMgr.setLastUpgrader(job, newHead);
            }
        }
    };

    public ConcurrentLockManager(int lockManagerShrinkTimer) throws ACIDException {
        this(lockManagerShrinkTimer, Runtime.getRuntime().availableProcessors() * 2, 1024);
    }

    public ConcurrentLockManager(int lockManagerShrinkTimer, int noArenas, int tableSize) throws ACIDException {
        this.table = new ResourceGroupTable(tableSize);
        this.resArenaMgr = new ResourceArenaManager(noArenas, lockManagerShrinkTimer);
        this.reqArenaMgr = new RequestArenaManager(noArenas, lockManagerShrinkTimer);
        this.jobArenaMgr = new JobArenaManager(noArenas, lockManagerShrinkTimer);
        this.txnId2TxnSlotMap = Long2LongMaps.synchronize((Long2LongMap)new Long2LongOpenHashMap());
    }

    public void lock(DatasetId datasetId, int entityHashValue, byte lockMode, ITransactionContext txnContext) throws ACIDException {
        this.log("lock", datasetId.getId(), entityHashValue, lockMode, txnContext);
        this.stats.lock();
        long txnId = txnContext.getTxnId().getId();
        long jobSlot = this.findOrAllocJobSlot(txnId);
        ResourceGroup group = this.table.get(datasetId.getId(), entityHashValue);
        group.getLatch();
        try {
            this.validateJob(txnContext);
            long resSlot = this.findOrAllocResourceSlot(group, datasetId.getId(), entityHashValue);
            long reqSlot = this.allocRequestSlot(resSlot, jobSlot, lockMode);
            boolean locked = false;
            block11: while (!locked) {
                LockAction act = this.determineLockAction(resSlot, jobSlot, lockMode);
                switch (act) {
                    case CONV: {
                        if (this.introducesDeadlock(resSlot, jobSlot, NOPTracker.INSTANCE)) {
                            CollectingTracker tracker = new CollectingTracker();
                            tracker.pushJob(jobSlot);
                            this.introducesDeadlock(resSlot, jobSlot, tracker);
                            this.requestAbort(txnContext, ((Object)tracker).toString());
                            continue block11;
                        }
                        if (this.hasOtherHolders(resSlot, jobSlot)) {
                            this.enqueueWaiter(group, reqSlot, resSlot, jobSlot, act, txnContext);
                            continue block11;
                        }
                    }
                    case UPD: {
                        this.resArenaMgr.setMaxMode(resSlot, lockMode);
                    }
                    case GET: {
                        this.addHolder(reqSlot, resSlot, jobSlot);
                        locked = true;
                        continue block11;
                    }
                    case WAIT: {
                        this.enqueueWaiter(group, reqSlot, resSlot, jobSlot, act, txnContext);
                        continue block11;
                    }
                }
                throw new IllegalStateException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ACIDException((Throwable)e);
        }
        finally {
            group.releaseLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueWaiter(ResourceGroup group, long reqSlot, long resSlot, long jobSlot, LockAction act, ITransactionContext txnContext) throws ACIDException, InterruptedException {
        Queue queue;
        Queue queue2 = queue = act.modify ? this.upgrader : this.waiter;
        if (this.introducesDeadlock(resSlot, jobSlot, NOPTracker.INSTANCE)) {
            CollectingTracker tracker = new CollectingTracker();
            tracker.pushJob(jobSlot);
            this.introducesDeadlock(resSlot, jobSlot, tracker);
            this.requestAbort(txnContext, ((Object)tracker).toString());
        } else {
            queue.add(reqSlot, resSlot, jobSlot);
        }
        try {
            group.await(txnContext);
        }
        finally {
            queue.remove(reqSlot, resSlot, jobSlot);
        }
    }

    private boolean introducesDeadlock(long resSlot, long jobSlot, DeadlockTracker tracker) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean introducesDeadlock(long resSlot, long jobSlot, DeadlockTracker tracker, int depth) {
        JobArenaManager jobArenaManager = this.jobArenaMgr;
        synchronized (jobArenaManager) {
            tracker.pushResource(resSlot);
            long reqSlot = this.resArenaMgr.getLastHolder(resSlot);
            while (reqSlot >= 0L) {
                tracker.pushRequest(reqSlot);
                long holderJobSlot = this.reqArenaMgr.getJobSlot(reqSlot);
                tracker.pushJob(holderJobSlot);
                if (holderJobSlot == jobSlot && depth != 0) {
                    return true;
                }
                boolean scanWaiters = true;
                long jobWaiter = this.jobArenaMgr.getLastWaiter(holderJobSlot);
                if (jobWaiter < 0L) {
                    scanWaiters = false;
                    jobWaiter = this.jobArenaMgr.getLastUpgrader(holderJobSlot);
                }
                while (jobWaiter >= 0L) {
                    long waitingOnResSlot = this.reqArenaMgr.getResourceId(jobWaiter);
                    if (this.introducesDeadlock(waitingOnResSlot, jobSlot, tracker, depth + 1)) {
                        return true;
                    }
                    if ((jobWaiter = this.reqArenaMgr.getNextJobRequest(jobWaiter)) >= 0L || !scanWaiters) continue;
                    scanWaiters = false;
                    jobWaiter = this.jobArenaMgr.getLastUpgrader(holderJobSlot);
                }
                tracker.pop();
                tracker.pop();
                reqSlot = this.reqArenaMgr.getNextRequest(reqSlot);
            }
            tracker.pop();
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public void instantLock(DatasetId datasetId, int entityHashValue, byte lockMode, ITransactionContext txnContext) throws ACIDException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 6[CASE], 11[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean tryLock(DatasetId datasetId, int entityHashValue, byte lockMode, ITransactionContext txnContext) throws ACIDException {
        this.log("tryLock", datasetId.getId(), entityHashValue, lockMode, txnContext);
        this.stats.tryLock();
        long txnId = txnContext.getTxnId().getId();
        long jobSlot = this.findOrAllocJobSlot(txnId);
        ResourceGroup group = this.table.get(datasetId.getId(), entityHashValue);
        group.getLatch();
        try {
            this.validateJob(txnContext);
            long resSlot = this.findOrAllocResourceSlot(group, datasetId.getId(), entityHashValue);
            long reqSlot = this.allocRequestSlot(resSlot, jobSlot, lockMode);
            LockAction act = this.determineLockAction(resSlot, jobSlot, lockMode);
            switch (act) {
                case UPD: {
                    this.resArenaMgr.setMaxMode(resSlot, lockMode);
                }
                case GET: {
                    this.addHolder(reqSlot, resSlot, jobSlot);
                    boolean bl = true;
                    return bl;
                }
                case CONV: 
                case WAIT: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new IllegalStateException();
        }
        finally {
            group.releaseLatch();
        }
    }

    public boolean instantTryLock(DatasetId datasetId, int entityHashValue, byte lockMode, ITransactionContext txnContext) throws ACIDException {
        this.log("instantTryLock", datasetId.getId(), entityHashValue, lockMode, txnContext);
        this.stats.instantTryLock();
        long txnId = txnContext.getTxnId().getId();
        ResourceGroup group = this.table.get(datasetId.getId(), entityHashValue);
        if (group.firstResourceIndex.get() == -1L) {
            this.validateJob(txnContext);
            return true;
        }
        group.getLatch();
        try {
            this.validateJob(txnContext);
            long resSlot = this.findResourceInGroup(group, datasetId.getId(), entityHashValue);
            if (resSlot < 0L) {
                boolean bl = true;
                return bl;
            }
            long jobSlot = this.findOrAllocJobSlot(txnId);
            LockAction act = this.determineLockAction(resSlot, jobSlot, lockMode);
            switch (act) {
                case UPD: 
                case GET: {
                    boolean bl = true;
                    return bl;
                }
                case CONV: 
                case WAIT: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new IllegalStateException();
        }
        finally {
            group.releaseLatch();
        }
    }

    public void unlock(DatasetId datasetId, int entityHashValue, byte lockMode, ITransactionContext txnContext) throws ACIDException {
        this.log("unlock", datasetId.getId(), entityHashValue, lockMode, txnContext);
        long txnId = txnContext.getTxnId().getId();
        long jobSlot = this.txnId2TxnSlotMap.get(txnId);
        this.unlock(datasetId.getId(), entityHashValue, lockMode, jobSlot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(int dsId, int entityHashValue, byte lockMode, long jobSlot) throws ACIDException {
        this.log("unlock", dsId, entityHashValue, lockMode, null);
        this.stats.unlock();
        ResourceGroup group = this.table.get(dsId, entityHashValue);
        group.getLatch();
        try {
            long resource = this.findResourceInGroup(group, dsId, entityHashValue);
            if (resource < 0L) {
                throw new IllegalStateException("resource (" + dsId + ",  " + entityHashValue + ") not found");
            }
            long holder = this.removeLastHolder(resource, jobSlot, lockMode);
            this.reqArenaMgr.deallocate(holder);
            if (this.resourceNotUsed(resource)) {
                long prev = group.firstResourceIndex.get();
                if (prev == resource) {
                    group.firstResourceIndex.set(this.resArenaMgr.getNext(resource));
                } else {
                    while (this.resArenaMgr.getNext(prev) != resource) {
                        prev = this.resArenaMgr.getNext(prev);
                    }
                    this.resArenaMgr.setNext(prev, this.resArenaMgr.getNext(resource));
                }
                this.resArenaMgr.deallocate(resource);
            } else {
                int oldMaxMode = this.resArenaMgr.getMaxMode(resource);
                int newMaxMode = this.determineNewMaxMode(resource, oldMaxMode);
                this.resArenaMgr.setMaxMode(resource, newMaxMode);
                group.wakeUp();
            }
        }
        finally {
            group.releaseLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLocks(ITransactionContext txnContext) throws ACIDException {
        long holder;
        this.log("releaseLocks", -1, -1, (byte)-1, txnContext);
        this.stats.releaseLocks();
        long txnId = txnContext.getTxnId().getId();
        long jobSlot = this.txnId2TxnSlotMap.get(txnId);
        if (jobSlot == 0L) {
            return;
        }
        if (LOGGER.isEnabled(LVL)) {
            LOGGER.log(LVL, "jobArenaMgr " + this.jobArenaMgr.addTo(new RecordManagerStats()).toString());
            LOGGER.log(LVL, "resArenaMgr " + this.resArenaMgr.addTo(new RecordManagerStats()).toString());
            LOGGER.log(LVL, "reqArenaMgr " + this.reqArenaMgr.addTo(new RecordManagerStats()).toString());
        }
        JobArenaManager jobArenaManager = this.jobArenaMgr;
        synchronized (jobArenaManager) {
            holder = this.jobArenaMgr.getLastHolder(jobSlot);
        }
        while (holder != -1L) {
            long resource = this.reqArenaMgr.getResourceId(holder);
            int dsId = this.resArenaMgr.getDatasetId(resource);
            int pkHashVal = this.resArenaMgr.getPkHashVal(resource);
            this.unlock(dsId, pkHashVal, (byte)-1, jobSlot);
            JobArenaManager jobArenaManager2 = this.jobArenaMgr;
            synchronized (jobArenaManager2) {
                holder = this.jobArenaMgr.getLastHolder(jobSlot);
            }
        }
        this.jobArenaMgr.deallocate(jobSlot);
        this.txnId2TxnSlotMap.remove(txnId);
        this.stats.logCounters(LOGGER, Level.DEBUG, true);
    }

    private long findOrAllocJobSlot(long txnId) {
        long jobSlot = this.txnId2TxnSlotMap.get(txnId);
        if (jobSlot == 0L) {
            jobSlot = this.jobArenaMgr.allocate();
            this.jobArenaMgr.setTxnId(jobSlot, txnId);
            long oldSlot = this.txnId2TxnSlotMap.putIfAbsent(txnId, jobSlot);
            if (oldSlot != 0L) {
                this.jobArenaMgr.deallocate(jobSlot);
                jobSlot = oldSlot;
            }
        }
        assert (jobSlot > 0L);
        return jobSlot;
    }

    private long findOrAllocResourceSlot(ResourceGroup group, int dsId, int entityHashValue) {
        long resSlot = this.findResourceInGroup(group, dsId, entityHashValue);
        if (resSlot == -1L) {
            resSlot = this.resArenaMgr.allocate();
            this.resArenaMgr.setDatasetId(resSlot, dsId);
            this.resArenaMgr.setPkHashVal(resSlot, entityHashValue);
            this.resArenaMgr.setNext(resSlot, group.firstResourceIndex.get());
            group.firstResourceIndex.set(resSlot);
        }
        return resSlot;
    }

    private long allocRequestSlot(long resSlot, long jobSlot, byte lockMode) {
        long reqSlot = this.reqArenaMgr.allocate();
        this.reqArenaMgr.setResourceId(reqSlot, resSlot);
        this.reqArenaMgr.setLockMode(reqSlot, lockMode);
        this.reqArenaMgr.setJobSlot(reqSlot, jobSlot);
        return reqSlot;
    }

    private LockAction determineLockAction(long resSlot, long jobSlot, byte lockMode) {
        int curLockMode = this.resArenaMgr.getMaxMode(resSlot);
        LockAction act = ACTION_MATRIX[curLockMode][lockMode];
        if (act == LockAction.WAIT) {
            return this.updateActionForSameJob(resSlot, jobSlot, lockMode);
        }
        return act;
    }

    private LockAction updateActionForSameJob(long resource, long job, byte lockMode) {
        long holder = this.resArenaMgr.getLastHolder(resource);
        LockAction res = LockAction.WAIT;
        while (holder != -1L) {
            if (job == this.reqArenaMgr.getJobSlot(holder)) {
                if (this.reqArenaMgr.getLockMode(holder) == lockMode) {
                    return LockAction.GET;
                }
                throw new IllegalStateException("Lock conversion is not supported when deadlock-free locking protocol is enabled!");
            }
            holder = this.reqArenaMgr.getNextRequest(holder);
        }
        return res;
    }

    private long findResourceInGroup(ResourceGroup group, int dsId, int entityHashValue) {
        this.stats.logCounters(LOGGER, LVL, false);
        long resSlot = group.firstResourceIndex.get();
        while (resSlot != -1L) {
            if (this.resArenaMgr.getDatasetId(resSlot) == dsId && this.resArenaMgr.getPkHashVal(resSlot) == entityHashValue) {
                return resSlot;
            }
            resSlot = this.resArenaMgr.getNext(resSlot);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHolder(long request, long resource, long job) {
        long lastHolder = this.resArenaMgr.getLastHolder(resource);
        this.reqArenaMgr.setNextRequest(request, lastHolder);
        this.resArenaMgr.setLastHolder(resource, request);
        JobArenaManager jobArenaManager = this.jobArenaMgr;
        synchronized (jobArenaManager) {
            long lastJobHolder = this.jobArenaMgr.getLastHolder(job);
            this.insertIntoJobQueue(request, lastJobHolder);
            this.jobArenaMgr.setLastHolder(job, request);
        }
    }

    private boolean hasOtherHolders(long resSlot, long jobSlot) {
        long holder = this.resArenaMgr.getLastHolder(resSlot);
        while (holder != -1L) {
            if (this.reqArenaMgr.getJobSlot(holder) != jobSlot) {
                return true;
            }
            holder = this.reqArenaMgr.getNextRequest(holder);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long removeLastHolder(long resource, long jobSlot, byte lockMode) {
        long holder = this.resArenaMgr.getLastHolder(resource);
        if (holder < 0L) {
            throw new IllegalStateException("no holder for resource " + resource);
        }
        if (this.requestMatches(holder, jobSlot, lockMode)) {
            long next = this.reqArenaMgr.getNextRequest(holder);
            this.resArenaMgr.setLastHolder(resource, next);
        } else {
            holder = this.removeRequestFromQueueForJob(holder, jobSlot, lockMode);
        }
        JobArenaManager jobArenaManager = this.jobArenaMgr;
        synchronized (jobArenaManager) {
            long newHead = this.removeRequestFromJob(holder, this.jobArenaMgr.getLastHolder(jobSlot));
            this.jobArenaMgr.setLastHolder(jobSlot, newHead);
        }
        return holder;
    }

    private boolean requestMatches(long holder, long jobSlot, byte lockMode) {
        return jobSlot == this.reqArenaMgr.getJobSlot(holder) && (lockMode == -1 || lockMode == this.reqArenaMgr.getLockMode(holder));
    }

    private long removeRequestFromJob(long holder, long unmodified) {
        long prevForJob = this.reqArenaMgr.getPrevJobRequest(holder);
        long nextForJob = this.reqArenaMgr.getNextJobRequest(holder);
        if (nextForJob != -1L) {
            this.reqArenaMgr.setPrevJobRequest(nextForJob, prevForJob);
        }
        if (prevForJob == -1L) {
            return nextForJob;
        }
        this.reqArenaMgr.setNextJobRequest(prevForJob, nextForJob);
        return unmodified;
    }

    private void insertIntoJobQueue(long newRequest, long oldRequest) {
        this.reqArenaMgr.setNextJobRequest(newRequest, oldRequest);
        this.reqArenaMgr.setPrevJobRequest(newRequest, -1L);
        if (oldRequest >= 0L) {
            this.reqArenaMgr.setPrevJobRequest(oldRequest, newRequest);
        }
    }

    private void appendToRequestQueue(long head, long appendee) {
        long next = this.reqArenaMgr.getNextRequest(head);
        while (next != -1L) {
            head = next;
            next = this.reqArenaMgr.getNextRequest(head);
        }
        this.reqArenaMgr.setNextRequest(head, appendee);
    }

    private long removeRequestFromQueueForSlot(long head, long reqSlot) {
        long cur;
        long prev = cur = head;
        while (prev != -1L) {
            cur = this.reqArenaMgr.getNextRequest(prev);
            if (cur == -1L) {
                throw new IllegalStateException("request " + reqSlot + " not in queue");
            }
            if (cur == reqSlot) break;
            prev = cur;
        }
        long next = this.reqArenaMgr.getNextRequest(cur);
        this.reqArenaMgr.setNextRequest(prev, next);
        return cur;
    }

    private long removeRequestFromQueueForJob(long head, long jobSlot, byte lockMode) {
        long holder;
        long prev = holder = head;
        while (prev != -1L) {
            holder = this.reqArenaMgr.getNextRequest(prev);
            if (holder == -1L) {
                throw new IllegalStateException("no entry for job " + jobSlot + " in queue");
            }
            if (this.requestMatches(holder, jobSlot, lockMode)) break;
            prev = holder;
        }
        long next = this.reqArenaMgr.getNextRequest(holder);
        this.reqArenaMgr.setNextRequest(prev, next);
        return holder;
    }

    private int determineNewMaxMode(long resource, int oldMaxMode) {
        int newMaxMode = 0;
        long holder = this.resArenaMgr.getLastHolder(resource);
        while (holder != -1L) {
            int curLockMode = this.reqArenaMgr.getLockMode(holder);
            if (curLockMode == oldMaxMode) {
                return oldMaxMode;
            }
            switch (ACTION_MATRIX[newMaxMode][curLockMode]) {
                case UPD: {
                    newMaxMode = curLockMode;
                    break;
                }
                case GET: {
                    break;
                }
                case CONV: 
                case WAIT: 
                case ERR: {
                    throw new IllegalStateException("incompatible locks in holder queue");
                }
            }
            holder = this.reqArenaMgr.getNextRequest(holder);
        }
        return newMaxMode;
    }

    private boolean resourceNotUsed(long resource) {
        return this.resArenaMgr.getLastHolder(resource) == -1L && this.resArenaMgr.getFirstUpgrader(resource) == -1L && this.resArenaMgr.getFirstWaiter(resource) == -1L;
    }

    private void validateJob(ITransactionContext txnContext) throws ACIDException {
        if (txnContext.getTxnState() == 2) {
            throw new ACIDException("" + txnContext.getTxnId() + " is in ABORTED state.");
        }
        if (txnContext.isTimeout()) {
            this.requestAbort(txnContext, "timeout");
        }
    }

    private void requestAbort(ITransactionContext txnContext, String msg) throws ACIDException {
        txnContext.setTimeout(true);
        throw new ACIDException("Transaction " + txnContext.getTxnId() + " should abort (requested by the Lock Manager):\n" + msg);
    }

    private void log(String string, int id, int entityHashValue, byte lockMode, ITransactionContext txnContext) {
        if (!LOGGER.isEnabled(LVL)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{ op : ").append(string);
        if (id != -1) {
            sb.append(" , dataset : ").append(id);
        }
        if (entityHashValue != -1) {
            sb.append(" , entity : ").append(entityHashValue);
        }
        if (lockMode != 0) {
            sb.append(" , mode : ").append(TransactionManagementConstants.LockManagerConstants.LockMode.toString(lockMode));
        }
        if (txnContext != null) {
            sb.append(" , txnId : ").append(txnContext.getTxnId());
        }
        sb.append(" , thread : ").append(Thread.currentThread().getName());
        sb.append(" }");
        LOGGER.log(LVL, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertLocksCanBefoundInJobQueue() throws ACIDException {
        try {
            for (int i = 0; i < this.table.size; ++i) {
                ResourceGroup group = this.table.get(i);
                if (group.tryLatch(100L, TimeUnit.MILLISECONDS)) {
                    try {
                        long resSlot = group.firstResourceIndex.get();
                        while (resSlot != -1L) {
                            int dsId = this.resArenaMgr.getDatasetId(resSlot);
                            int entityHashValue = this.resArenaMgr.getPkHashVal(resSlot);
                            long reqSlot = this.resArenaMgr.getLastHolder(resSlot);
                            while (reqSlot != -1L) {
                                byte lockMode = (byte)this.reqArenaMgr.getLockMode(reqSlot);
                                long jobSlot = this.reqArenaMgr.getJobSlot(reqSlot);
                                long txnId = this.jobArenaMgr.getTxnId(jobSlot);
                                this.assertLockCanBeFoundInJobQueue(dsId, entityHashValue, lockMode, txnId);
                                reqSlot = this.reqArenaMgr.getNextRequest(reqSlot);
                            }
                            resSlot = this.resArenaMgr.getNext(resSlot);
                        }
                        continue;
                    }
                    finally {
                        group.releaseLatch();
                    }
                }
                LOGGER.warn("Could not check locks for " + group);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("interrupted", e);
        }
    }

    private void assertLockCanBeFoundInJobQueue(int dsId, int entityHashValue, byte lockMode, long txnId) {
        if (this.findLockInJobQueue(dsId, entityHashValue, txnId, lockMode) == -1L) {
            String msg = "request for " + TransactionManagementConstants.LockManagerConstants.LockMode.toString(lockMode) + " lock on dataset " + dsId + " entity " + entityHashValue + " not found for txn " + txnId + " in thread " + Thread.currentThread().getName();
            LOGGER.error(msg);
            throw new IllegalStateException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findLockInJobQueue(int dsId, int entityHashValue, long txnId, byte lockMode) {
        long holder;
        long jobSlot = this.txnId2TxnSlotMap.get(txnId);
        if (jobSlot == 0L) {
            return -1L;
        }
        JobArenaManager jobArenaManager = this.jobArenaMgr;
        synchronized (jobArenaManager) {
            holder = this.jobArenaMgr.getLastHolder(jobSlot);
        }
        while (holder != -1L) {
            long resource = this.reqArenaMgr.getResourceId(holder);
            if (dsId == this.resArenaMgr.getDatasetId(resource) && entityHashValue == this.resArenaMgr.getPkHashVal(resource) && jobSlot == this.reqArenaMgr.getJobSlot(holder) && (lockMode == this.reqArenaMgr.getLockMode(holder) || lockMode == -1)) {
                return holder;
            }
            JobArenaManager jobArenaManager2 = this.jobArenaMgr;
            synchronized (jobArenaManager2) {
                holder = this.reqArenaMgr.getNextJobRequest(holder);
            }
        }
        return -1L;
    }

    private TablePrinter getResourceTablePrinter() {
        return new ResourceTablePrinter(this.table, this.resArenaMgr, this.reqArenaMgr, this.jobArenaMgr);
    }

    private TablePrinter getDumpTablePrinter() {
        return new DumpTablePrinter(this.table, this.resArenaMgr, this.reqArenaMgr, this.jobArenaMgr, this.txnId2TxnSlotMap);
    }

    public String printByResource() {
        return this.getResourceTablePrinter().append(new StringBuilder()).append("\n").toString();
    }

    public String toString() {
        return this.printByResource();
    }

    public String dump() {
        return this.getDumpTablePrinter().append(new StringBuilder()).toString();
    }

    public String prettyPrint() throws ACIDException {
        StringBuilder s = new StringBuilder("\n########### LockManager Status #############\n");
        return this.getDumpTablePrinter().append(s).toString() + "\n";
    }

    public void start() {
    }

    public void dumpState(OutputStream os) throws IOException {
        os.write(this.dump().getBytes());
    }

    public void stop(boolean dumpState, OutputStream os) throws IOException {
        if (dumpState) {
            this.dumpState(os);
        }
    }

    static interface Queue {
        public void add(long var1, long var3, long var5);

        public void remove(long var1, long var3, long var5);
    }

    private static class CollectingTracker
    implements DeadlockTracker {
        static final boolean DEBUG = false;
        LongList slots = new LongArrayList();
        ArrayList<String> types = new ArrayList();

        private CollectingTracker() {
        }

        @Override
        public void pushResource(long resSlot) {
            this.types.add("Resource");
            this.slots.add(resSlot);
        }

        @Override
        public void pushRequest(long reqSlot) {
            this.types.add("Request");
            this.slots.add(reqSlot);
        }

        @Override
        public void pushJob(long jobSlot) {
            this.types.add("Job");
            this.slots.add(jobSlot);
        }

        @Override
        public void pop() {
            this.types.remove(this.types.size() - 1);
            this.slots.removeLong(this.slots.size() - 1);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.slots.size(); ++i) {
                sb.append(this.types.get(i)).append(" ").append(TypeUtil.Global.toString(this.slots.getLong(i))).append("\n");
            }
            return sb.toString();
        }
    }

    private static class NOPTracker
    implements DeadlockTracker {
        static final DeadlockTracker INSTANCE = new NOPTracker();

        private NOPTracker() {
        }

        @Override
        public void pushResource(long resSlot) {
        }

        @Override
        public void pushRequest(long reqSlot) {
        }

        @Override
        public void pushJob(long jobSlot) {
        }

        @Override
        public void pop() {
        }
    }

    static interface DeadlockTracker {
        public void pushResource(long var1);

        public void pushRequest(long var1);

        public void pushJob(long var1);

        public void pop();
    }

    static enum LockAction {
        ERR(false, false),
        GET(false, false),
        UPD(false, true),
        WAIT(true, false),
        CONV(true, true);

        boolean wait;
        boolean modify;

        private LockAction(boolean wait, boolean modify) {
            this.wait = wait;
            this.modify = modify;
        }
    }
}

