/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.bitwise;

import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractBitSingleValueEvaluator
extends AbstractScalarEval {
    final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final IScalarEvaluator valueEvaluator;
    private final IPointable valuePointable = VoidPointable.FACTORY.createPointable();
    private final IEvaluatorContext context;

    AbstractBitSingleValueEvaluator(IEvaluatorContext context, IScalarEvaluatorFactory[] argEvaluatorFactories, FunctionIdentifier functionIdentifier, SourceLocation sourceLocation) throws HyracksDataException {
        super(sourceLocation, functionIdentifier);
        this.context = context;
        this.valueEvaluator = argEvaluatorFactories[0].createScalarEvaluator(context);
    }

    abstract void applyBitwiseOperation(long var1);

    abstract void writeResult(IPointable var1) throws HyracksDataException;

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int startOffset;
        this.valueEvaluator.evaluate(tuple, this.valuePointable);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.valuePointable)) {
            return;
        }
        byte[] bytes = this.valuePointable.getByteArray();
        if (!PointableHelper.isValidLongValue(bytes, startOffset = this.valuePointable.getStartOffset(), true)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)bytes[startOffset], (int)0, (ATypeTag)ATypeTag.BIGINT);
            PointableHelper.setNull(result);
            return;
        }
        long longValue = ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)0, (byte[])bytes, (int)startOffset);
        this.applyBitwiseOperation(longValue);
        this.writeResult(result);
    }
}

