/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.ILibrary;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.api.IDataParserFactory;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.library.JavaLibrary;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.functions.StringEvaluatorUtils;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.data.parsers.BooleanParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.DoubleParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.FloatParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.IntegerParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.LongParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.UTF8StringParserFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;

public class ExternalDataUtils {
    private static final Map<ATypeTag, IValueParserFactory> valueParserFactoryMap = new EnumMap<ATypeTag, IValueParserFactory>(ATypeTag.class);

    private ExternalDataUtils() {
    }

    public static char validateGetDelimiter(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "delimiter", ",".charAt(0));
    }

    public static char validateGetQuote(Map<String, String> configuration, char delimiter) throws HyracksDataException {
        char quote = ExternalDataUtils.validateCharOrDefault(configuration, "quote", "\"".charAt(0));
        ExternalDataUtils.validateDelimiterAndQuote(delimiter, quote);
        return quote;
    }

    public static char validateGetEscape(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "escape", '\\');
    }

    public static char validateGetRecordStart(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "record-start", '{');
    }

    public static char validateGetRecordEnd(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "record-end", '}');
    }

    public static void validateDataParserParameters(Map<String, String> configuration) throws AsterixException {
        String parserFactory;
        String parser = configuration.get("format");
        if (parser == null && (parserFactory = configuration.get("parser-factory")) == null) {
            throw AsterixException.create((int)49, (Serializable[])new Serializable[]{"format or parser-factory"});
        }
    }

    public static void validateDataSourceParameters(Map<String, String> configuration) throws AsterixException {
        String reader = configuration.get("reader");
        if (reader == null) {
            throw AsterixException.create((int)49, (Serializable[])new Serializable[]{"reader"});
        }
    }

    public static IExternalDataSourceFactory.DataSourceType getDataSourceType(Map<String, String> configuration) {
        String reader = configuration.get("reader");
        if (reader != null && reader.equals("stream")) {
            return IExternalDataSourceFactory.DataSourceType.STREAM;
        }
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    public static boolean isExternal(String aString) {
        return aString != null && aString.contains("#") && aString.trim().length() > 1;
    }

    public static String getLibraryName(String aString) {
        return aString.trim().split("#")[0];
    }

    public static String getExternalClassName(String aString) {
        return aString.trim().split("#")[1];
    }

    public static IInputStreamFactory createExternalInputStreamFactory(ILibraryManager libraryManager, DataverseName dataverse, String stream) throws HyracksDataException {
        try {
            String libraryName = ExternalDataUtils.getLibraryName(stream);
            String className = ExternalDataUtils.getExternalClassName(stream);
            ILibrary lib = libraryManager.getLibrary(dataverse, libraryName);
            if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
                throw new HyracksDataException("Unexpected library language: " + lib.getLanguage());
            }
            ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
            return (IInputStreamFactory)classLoader.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeDataException(3024, (Throwable)e, new Serializable[0]);
        }
    }

    public static DataverseName getDataverse(Map<String, String> configuration) {
        return DataverseName.createFromCanonicalForm((String)configuration.get("dataverse"));
    }

    public static String getParserFactory(Map<String, String> configuration) {
        String parserFactory = configuration.get("parser");
        if (parserFactory != null) {
            return parserFactory;
        }
        parserFactory = configuration.get("format");
        return parserFactory != null ? parserFactory : configuration.get("parser-factory");
    }

    public static IValueParserFactory[] getValueParserFactories(ARecordType recordType) {
        int n = recordType.getFieldTypes().length;
        IValueParserFactory[] fieldParserFactories = new IValueParserFactory[n];
        for (int i = 0; i < n; ++i) {
            ATypeTag tag = null;
            if (recordType.getFieldTypes()[i].getTypeTag() == ATypeTag.UNION) {
                AUnionType unionType = (AUnionType)recordType.getFieldTypes()[i];
                if (!unionType.isUnknownableType()) {
                    throw new NotImplementedException("Non-optional UNION type is not supported.");
                }
                tag = unionType.getActualType().getTypeTag();
            } else {
                tag = recordType.getFieldTypes()[i].getTypeTag();
            }
            if (tag == null) {
                throw new NotImplementedException("Failed to get the type information for field " + i + ".");
            }
            fieldParserFactories[i] = ExternalDataUtils.getParserFactory(tag);
        }
        return fieldParserFactories;
    }

    public static IValueParserFactory getParserFactory(ATypeTag tag) {
        IValueParserFactory vpf = valueParserFactoryMap.get(tag);
        if (vpf == null) {
            throw new NotImplementedException("No value parser factory for fields of type " + tag);
        }
        return vpf;
    }

    public static boolean hasHeader(Map<String, String> configuration) {
        return ExternalDataUtils.isTrue(configuration, "header");
    }

    public static boolean isTrue(Map<String, String> configuration, String key) {
        String value = configuration.get(key);
        return value == null ? false : Boolean.valueOf(value);
    }

    public static IRecordReaderFactory<?> createExternalRecordReaderFactory(ILibraryManager libraryManager, Map<String, String> configuration) throws AsterixException {
        ILibrary lib;
        String readerFactory = configuration.get("reader-factory");
        if (readerFactory == null) {
            throw new AsterixException("to use external reader, the parameter reader-factory must be specified.");
        }
        String[] libraryAndFactory = readerFactory.split("#");
        if (libraryAndFactory.length != 2) {
            throw new AsterixException("The parameter reader-factory must follow the format \"DataverseName.LibraryName#ReaderFactoryFullyQualifiedName\"");
        }
        String[] dataverseAndLibrary = libraryAndFactory[0].split("\\.");
        if (dataverseAndLibrary.length != 2) {
            throw new AsterixException("The parameter reader-factory must follow the format \"DataverseName.LibraryName#ReaderFactoryFullyQualifiedName\"");
        }
        DataverseName dataverseName = DataverseName.createSinglePartName((String)dataverseAndLibrary[0]);
        String libraryName = dataverseAndLibrary[1];
        try {
            lib = libraryManager.getLibrary(dataverseName, libraryName);
        }
        catch (HyracksDataException e) {
            throw new AsterixException("Cannot load library", (Throwable)e);
        }
        if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
            throw new AsterixException("Unexpected library language: " + lib.getLanguage());
        }
        ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
        try {
            return (IRecordReaderFactory)classLoader.loadClass(libraryAndFactory[1]).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Failed to create record reader factory", (Throwable)e);
        }
    }

    public static IDataParserFactory createExternalParserFactory(ILibraryManager libraryManager, DataverseName dataverse, String parserFactoryName) throws AsterixException {
        try {
            ILibrary lib;
            String library = parserFactoryName.substring(0, parserFactoryName.indexOf("#"));
            try {
                lib = libraryManager.getLibrary(dataverse, library);
            }
            catch (HyracksDataException e) {
                throw new AsterixException("Cannot load library", (Throwable)e);
            }
            if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
                throw new AsterixException("Unexpected library language: " + lib.getLanguage());
            }
            ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
            return (IDataParserFactory)classLoader.loadClass(parserFactoryName.substring(parserFactoryName.indexOf("#") + 1)).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Failed to create an external parser factory", (Throwable)e);
        }
    }

    public static boolean isFeed(Map<String, String> configuration) {
        if (!configuration.containsKey("is-feed")) {
            return false;
        }
        return Boolean.parseBoolean(configuration.get("is-feed"));
    }

    public static void prepareFeed(Map<String, String> configuration, DataverseName dataverseName, String feedName) {
        if (!configuration.containsKey("is-feed")) {
            configuration.put("is-feed", "true");
        }
        configuration.put("dataverse", dataverseName.getCanonicalForm());
        configuration.put("feed", feedName);
    }

    public static boolean keepDataSourceOpen(Map<String, String> configuration) {
        if (!configuration.containsKey("wait-for-data")) {
            return true;
        }
        return Boolean.parseBoolean(configuration.get("wait-for-data"));
    }

    public static String getFeedName(Map<String, String> configuration) {
        return configuration.get("feed");
    }

    public static boolean isRecordWithMeta(Map<String, String> configuration) {
        return configuration.containsKey("meta-type-name");
    }

    public static void setRecordWithMeta(Map<String, String> configuration, String booleanString) {
        configuration.put("record-with-metadata", booleanString);
    }

    public static boolean isChangeFeed(Map<String, String> configuration) {
        return Boolean.parseBoolean(configuration.get("change-feed"));
    }

    public static boolean isInsertFeed(Map<String, String> configuration) {
        return Boolean.parseBoolean(configuration.get("insert-feed"));
    }

    public static int getNumberOfKeys(Map<String, String> configuration) throws AsterixException {
        String keyIndexes = configuration.get("key-indexes");
        if (keyIndexes == null) {
            throw AsterixException.create((int)49, (Serializable[])new Serializable[]{"key-indexes"});
        }
        return keyIndexes.split(",").length;
    }

    public static void setNumberOfKeys(Map<String, String> configuration, int value) {
        configuration.put("key-size", String.valueOf(value));
    }

    public static void setChangeFeed(Map<String, String> configuration, String booleanString) {
        configuration.put("change-feed", booleanString);
    }

    public static int[] getPKIndexes(Map<String, String> configuration) {
        String keyIndexes = configuration.get("key-indexes");
        String[] stringIndexes = keyIndexes.split(",");
        int[] intIndexes = new int[stringIndexes.length];
        for (int i = 0; i < stringIndexes.length; ++i) {
            intIndexes[i] = Integer.parseInt(stringIndexes[i]);
        }
        return intIndexes;
    }

    public static int[] getPKSourceIndicators(Map<String, String> configuration) {
        String keyIndicators = configuration.get("key-indicators");
        String[] stringIndicators = keyIndicators.split(",");
        int[] intIndicators = new int[stringIndicators.length];
        for (int i = 0; i < stringIndicators.length; ++i) {
            intIndicators[i] = Integer.parseInt(stringIndicators[i]);
        }
        return intIndicators;
    }

    public static void defaultConfiguration(Map<String, String> configuration) {
        String format = configuration.get("format");
        if (format != null) {
            if (format.equals("csv")) {
                configuration.putIfAbsent("delimiter", ",");
                configuration.putIfAbsent("quote", "\"");
                configuration.putIfAbsent("escape", "\"");
            } else if (format.equals("tsv")) {
                configuration.putIfAbsent("delimiter", "\t");
                configuration.putIfAbsent("quote", "\u0000");
                configuration.putIfAbsent("escape", "\u0000");
            }
        }
    }

    public static void prepare(String adapterName, Map<String, String> configuration) {
        if (!configuration.containsKey("reader")) {
            configuration.put("reader", adapterName);
        }
        if (!configuration.containsKey("parser") && configuration.containsKey("format")) {
            configuration.put("parser", configuration.get("format"));
        }
    }

    public static void normalize(Map<String, String> configuration) {
        String lowerCaseFormat;
        String paramValue = configuration.get("format");
        if (paramValue != null && ExternalDataConstants.ALL_FORMATS.contains(lowerCaseFormat = paramValue.toLowerCase().trim())) {
            configuration.put("format", lowerCaseFormat);
        }
        ExternalDataUtils.putToLowerIfExists(configuration, "header");
        ExternalDataUtils.putToLowerIfExists(configuration, "redact-warnings");
    }

    public static void validate(Map<String, String> configuration) throws HyracksDataException {
        String format = configuration.get("format");
        String header = configuration.get("header");
        if (format != null && ExternalDataUtils.isHeaderRequiredFor(format) && header == null) {
            throw new RuntimeDataException(49, new Serializable[]{"header"});
        }
        if (header != null && !ExternalDataUtils.isBoolean(header)) {
            throw new RuntimeDataException(47, new Serializable[]{"header", header});
        }
        char delimiter = ExternalDataUtils.validateGetDelimiter(configuration);
        ExternalDataUtils.validateGetQuote(configuration, delimiter);
        ExternalDataUtils.validateGetEscape(configuration);
        String value = configuration.get("redact-warnings");
        if (value != null && !ExternalDataUtils.isBoolean(value)) {
            throw new RuntimeDataException(47, new Serializable[]{"redact-warnings", value});
        }
    }

    private static boolean isHeaderRequiredFor(String format) {
        return format.equals("csv") || format.equals("tsv");
    }

    private static boolean isBoolean(String value) {
        return value.equals("true") || value.equals("false");
    }

    private static void validateDelimiterAndQuote(char delimiter, char quote) throws RuntimeDataException {
        if (quote == delimiter) {
            throw new RuntimeDataException(3051, new Serializable[]{Character.valueOf(quote), Character.valueOf(delimiter)});
        }
    }

    private static char validateCharOrDefault(Map<String, String> configuration, String key, char defaultValue) throws HyracksDataException {
        String value = configuration.get(key);
        if (value == null) {
            return defaultValue;
        }
        ExternalDataUtils.validateChar(value, key);
        return value.charAt(0);
    }

    public static void validateChar(String parameterValue, String parameterName) throws RuntimeDataException {
        if (parameterValue.length() != 1) {
            throw new RuntimeDataException(3050, new Serializable[]{parameterValue, parameterName});
        }
    }

    private static void putToLowerIfExists(Map<String, String> configuration, String key) {
        String paramValue = configuration.get(key);
        if (paramValue != null) {
            configuration.put(key, paramValue.toLowerCase().trim());
        }
    }

    public static void validateAdapterSpecificProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector) throws CompilationException {
        String type;
        switch (type = configuration.get("type")) {
            case "S3": {
                AwsS3.validateProperties(configuration, srcLoc, collector);
                break;
            }
        }
    }

    public static boolean matchPatterns(List<Matcher> matchers, String path) {
        for (Matcher matcher : matchers) {
            if (!matcher.reset(path).matches()) continue;
            return true;
        }
        return false;
    }

    public static String patternToRegex(String pattern) {
        int charPosition = 0;
        int patternLength = pattern.length();
        StringBuilder stuffBuilder = new StringBuilder();
        StringBuilder result = new StringBuilder();
        block5: while (charPosition < patternLength) {
            char c = pattern.charAt(charPosition);
            ++charPosition;
            switch (c) {
                case '*': {
                    result.append(".*");
                    continue block5;
                }
                case '?': {
                    result.append(".");
                    continue block5;
                }
                case '[': {
                    int closingBracketPosition = charPosition;
                    if (closingBracketPosition < patternLength && pattern.charAt(closingBracketPosition) == '!') {
                        ++closingBracketPosition;
                    }
                    if (closingBracketPosition < patternLength && pattern.charAt(closingBracketPosition) == ']') {
                        ++closingBracketPosition;
                    }
                    while (closingBracketPosition < patternLength && pattern.charAt(closingBracketPosition) != ']') {
                        ++closingBracketPosition;
                    }
                    if (closingBracketPosition >= patternLength) {
                        result.append("\\[");
                        continue block5;
                    }
                    String stuff = pattern.substring(charPosition, closingBracketPosition);
                    stuffBuilder.setLength(0);
                    int stuffCharPos = 0;
                    if (stuff.charAt(0) == '!') {
                        stuffBuilder.append('^');
                        ++stuffCharPos;
                    }
                    while (stuffCharPos < stuff.length()) {
                        char stuffChar = stuff.charAt(stuffCharPos);
                        if (stuffChar != '-' && Arrays.binarySearch(StringEvaluatorUtils.RESERVED_REGEX_CHARS, stuffChar) >= 0) {
                            stuffBuilder.append("\\");
                        }
                        stuffBuilder.append(stuffChar);
                        ++stuffCharPos;
                    }
                    String stuffEscaped = stuffBuilder.toString();
                    stuffEscaped = stuffEscaped.replace("&&", "\\&\\&").replace("~~", "\\~\\~").replace("||", "\\|\\|").replace("--", "\\-\\-");
                    result.append("[").append(stuffEscaped).append("]");
                    charPosition = closingBracketPosition + 1;
                    continue block5;
                }
            }
            if (Arrays.binarySearch(StringEvaluatorUtils.RESERVED_REGEX_CHARS, c) >= 0) {
                result.append("\\");
            }
            result.append(c);
        }
        return result.toString();
    }

    static {
        valueParserFactoryMap.put(ATypeTag.INTEGER, IntegerParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.FLOAT, FloatParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.DOUBLE, DoubleParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.BIGINT, LongParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.STRING, UTF8StringParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.BOOLEAN, BooleanParserFactory.INSTANCE);
    }

    public static class AwsS3 {
        private AwsS3() {
            throw new AssertionError((Object)"do not instantiate");
        }

        public static S3Client buildAwsS3Client(Map<String, String> configuration) throws CompilationException {
            String accessKeyId = configuration.get("accessKeyId");
            String secretAccessKey = configuration.get("secretAccessKey");
            String regionId = configuration.get("region");
            String serviceEndpoint = configuration.get("serviceEndpoint");
            S3ClientBuilder builder = S3Client.builder();
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey);
            builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials));
            List supportedRegions = S3Client.serviceMetadata().regions();
            Optional<Region> selectedRegion = supportedRegions.stream().filter(region -> region.id().equalsIgnoreCase(regionId)).findFirst();
            if (!selectedRegion.isPresent()) {
                throw new CompilationException(1108, new Serializable[]{String.format("region %s is not supported", regionId)});
            }
            builder.region(selectedRegion.get());
            if (serviceEndpoint != null) {
                try {
                    URI uri = new URI(serviceEndpoint);
                    try {
                        builder.endpointOverride(uri);
                    }
                    catch (NullPointerException ex) {
                        throw new CompilationException(1108, new Serializable[]{ex.getMessage()});
                    }
                }
                catch (URISyntaxException ex) {
                    throw new CompilationException(1108, new Serializable[]{String.format("Invalid service endpoint %s", serviceEndpoint)});
                }
            }
            return (S3Client)builder.build();
        }

        public static void setPrefix(Map<String, String> configuration, ListObjectsV2Request.Builder builder) {
            String definition = configuration.get("definition");
            if (definition != null) {
                builder.prefix(definition + (!definition.isEmpty() && !definition.endsWith("/") ? "/" : ""));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void validateProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector) throws CompilationException {
            if (configuration.get("format") == null) {
                throw new CompilationException(49, srcLoc, new Serializable[]{"format"});
            }
            AwsS3.validateIncludeExclude(configuration);
            S3Client s3Client = null;
            try {
                String container = configuration.get("container");
                s3Client = AwsS3.buildAwsS3Client(configuration);
                ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder();
                AwsS3.setPrefix(configuration, listObjectsBuilder);
                ListObjectsV2Response response = s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.bucket(container).maxKeys(Integer.valueOf(1)).build());
                if (response.contents().isEmpty() && collector.shouldWarn()) {
                    Warning warning = WarningUtil.forAsterix((SourceLocation)srcLoc, (int)1114, (Serializable[])new Serializable[0]);
                    collector.warn(warning);
                }
                if (!response.sdkHttpResponse().isSuccessful()) {
                    throw new CompilationException(1109, new Serializable[]{container});
                }
                if (s3Client == null) return;
            }
            catch (SdkException ex) {
                try {
                    throw new CompilationException(1108, new Serializable[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    if (s3Client == null) throw throwable;
                    CleanupUtils.close(s3Client, null);
                    throw throwable;
                }
            }
            CleanupUtils.close((AutoCloseable)s3Client, null);
            return;
        }

        public static void validateIncludeExclude(Map<String, String> configuration) throws CompilationException {
            ArrayList<Map.Entry<String, String>> includes = new ArrayList<Map.Entry<String, String>>();
            ArrayList<Map.Entry<String, String>> excludes = new ArrayList<Map.Entry<String, String>>();
            for (Map.Entry<String, String> entry : configuration.entrySet()) {
                String key = entry.getKey();
                if (key.equals("include")) {
                    includes.add(entry);
                    continue;
                }
                if (key.equals("exclude")) {
                    excludes.add(entry);
                    continue;
                }
                if (!key.startsWith("include") && !key.startsWith("exclude")) continue;
                String[] splits = key.split("#");
                if (key.startsWith("include") && splits.length == 2 && splits[0].equals("include") && NumberUtils.isIntegerNumericString((String)splits[1])) {
                    includes.add(entry);
                    continue;
                }
                if (key.startsWith("exclude") && splits.length == 2 && splits[0].equals("exclude") && NumberUtils.isIntegerNumericString((String)splits[1])) {
                    excludes.add(entry);
                    continue;
                }
                throw new CompilationException(1112, new Serializable[]{key});
            }
            if (!includes.isEmpty() && !excludes.isEmpty()) {
                throw new CompilationException(1110, new Serializable[]{"include", "exclude"});
            }
        }
    }
}

