/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreObjectResponse
extends S3Response
implements ToCopyableBuilder<Builder, RestoreObjectResponse> {
    private static final SdkField<String> REQUEST_CHARGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreObjectResponse.getter(RestoreObjectResponse::requestChargedAsString)).setter(RestoreObjectResponse.setter(Builder::requestCharged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-request-charged").unmarshallLocationName("x-amz-request-charged").build()}).build();
    private static final SdkField<String> RESTORE_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreObjectResponse.getter(RestoreObjectResponse::restoreOutputPath)).setter(RestoreObjectResponse.setter(Builder::restoreOutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-restore-output-path").unmarshallLocationName("x-amz-restore-output-path").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_CHARGED_FIELD, RESTORE_OUTPUT_PATH_FIELD));
    private final String requestCharged;
    private final String restoreOutputPath;

    private RestoreObjectResponse(BuilderImpl builder) {
        super(builder);
        this.requestCharged = builder.requestCharged;
        this.restoreOutputPath = builder.restoreOutputPath;
    }

    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(this.requestCharged);
    }

    public String requestChargedAsString() {
        return this.requestCharged;
    }

    public String restoreOutputPath() {
        return this.restoreOutputPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestChargedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreOutputPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreObjectResponse)) {
            return false;
        }
        RestoreObjectResponse other = (RestoreObjectResponse)((Object)obj);
        return Objects.equals(this.requestChargedAsString(), other.requestChargedAsString()) && Objects.equals(this.restoreOutputPath(), other.restoreOutputPath());
    }

    public String toString() {
        return ToString.builder((String)"RestoreObjectResponse").add("RequestCharged", (Object)this.requestChargedAsString()).add("RestoreOutputPath", (Object)this.restoreOutputPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestCharged": {
                return Optional.ofNullable(clazz.cast(this.requestChargedAsString()));
            }
            case "RestoreOutputPath": {
                return Optional.ofNullable(clazz.cast(this.restoreOutputPath()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreObjectResponse, T> g) {
        return obj -> g.apply((RestoreObjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private String requestCharged;
        private String restoreOutputPath;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreObjectResponse model) {
            super(model);
            this.requestCharged(model.requestCharged);
            this.restoreOutputPath(model.restoreOutputPath);
        }

        public final String getRequestChargedAsString() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged == null ? null : requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final String getRestoreOutputPath() {
            return this.restoreOutputPath;
        }

        @Override
        public final Builder restoreOutputPath(String restoreOutputPath) {
            this.restoreOutputPath = restoreOutputPath;
            return this;
        }

        public final void setRestoreOutputPath(String restoreOutputPath) {
            this.restoreOutputPath = restoreOutputPath;
        }

        @Override
        public RestoreObjectResponse build() {
            return new RestoreObjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreObjectResponse> {
        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);

        public Builder restoreOutputPath(String var1);
    }
}

