/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.struct;

public enum OperatorType {
    OR("or"),
    AND("and"),
    LT("<"),
    GT(">"),
    LE("<="),
    GE(">="),
    EQ("="),
    NEQ("!="),
    PLUS("+"),
    MINUS("-"),
    CONCAT("||"),
    MUL("*"),
    DIVIDE("/"),
    DIV("div"),
    MOD("mod"),
    CARET("^"),
    FUZZY_EQ("~="),
    LIKE("like"),
    NOT_LIKE("not_like"),
    IN("in"),
    NOT_IN("not_in"),
    BETWEEN("between"),
    NOT_BETWEEN("not_between");

    private static final OperatorType[] VALUES;
    private final String symbol;

    private OperatorType(String s) {
        this.symbol = s;
    }

    public String toString() {
        return this.symbol;
    }

    public static OperatorType fromSymbol(String symbol) {
        for (OperatorType opType : VALUES) {
            if (!opType.symbol.equals(symbol)) continue;
            return opType;
        }
        return null;
    }

    static {
        VALUES = OperatorType.values();
    }
}

