/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.exceptions;

import java.util.function.Predicate;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IFormattedException;

public class ExceptionUtils {
    public static final String INCORRECT_PARAMETER = "Incorrect parameter.\n";
    public static final String PARAMETER_NAME = "Parameter name: ";
    public static final String EXPECTED_VALUE = "Expected value: ";
    public static final String PASSED_VALUE = "Passed value: ";

    private ExceptionUtils() {
    }

    public static String incorrectParameterMessage(String parameterName, String expectedValue, String passedValue) {
        return "Incorrect parameter.\nParameter name: " + parameterName + System.lineSeparator() + EXPECTED_VALUE + expectedValue + System.lineSeparator() + PASSED_VALUE + passedValue;
    }

    public static String getErrorMessage(Throwable th) {
        Throwable cause = ExceptionUtils.getRootCause(th);
        return cause.getMessage();
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable current = e;
        Throwable cause = e.getCause();
        while (cause != null && cause != current) {
            current = cause;
            cause = current.getCause();
        }
        return current;
    }

    public static Throwable getCause(Throwable e, String component, int code) {
        Throwable current = e;
        Throwable expected = current instanceof HyracksDataException && ((HyracksDataException)current).getErrorCode() == code && ((HyracksDataException)current).getComponent().equals(component) ? current : null;
        Throwable cause = e.getCause();
        while (cause != null && cause != current) {
            current = cause;
            expected = current instanceof HyracksDataException && ((HyracksDataException)current).getErrorCode() == code && ((HyracksDataException)current).getComponent().equals(component) ? current : expected;
            cause = current.getCause();
        }
        return expected == null ? current : expected;
    }

    public static boolean matchingCause(Throwable e, Predicate<Throwable> test) {
        Throwable current = e;
        Throwable cause = e.getCause();
        while (cause != null && cause != current) {
            if (test.test(cause)) {
                return true;
            }
            Throwable nextCause = current.getCause();
            current = cause;
            cause = nextCause;
        }
        return test.test(e);
    }

    public static Throwable unwrap(Throwable e) {
        Throwable current = e;
        Throwable cause = e.getCause();
        while (cause != null && cause != current && current instanceof IFormattedException) {
            current = cause;
            cause = current.getCause();
        }
        return current;
    }
}

