/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.asterix.lang.sqlpp.rewrites;

import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.base.IStatementRewriter;

class SqlppFunctionBodyRewriterFactory implements IRewriterFactory {

    private final IParserFactory parserFactory;

    public SqlppFunctionBodyRewriterFactory(IParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    @Override
    public IQueryRewriter createQueryRewriter() {
        return new SqlppFunctionBodyRewriter(parserFactory);
    }

    @Override
    public IStatementRewriter createStatementRewriter() {
        throw new IllegalStateException("There could not be non-query statements inside a function definition.");
    }

}
