/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.NullLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SetOperationVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByVisitor;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.FreeVariableVisitor;
import org.apache.asterix.lang.sqlpp.visitor.SqlppSubstituteExpressionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;

public final class SqlppGroupingSetsVisitor
extends AbstractSqlppExpressionScopingVisitor {
    private final List<List<GbyVariableExpressionPair>> tmpGroupingSets = new ArrayList<List<GbyVariableExpressionPair>>(1);
    private final List<GbyVariableExpressionPair> tmpDecorPairList = new ArrayList<GbyVariableExpressionPair>();
    private final Set<VariableExpr> tmpAllGroupingSetsVars = new LinkedHashSet<VariableExpr>();
    private final Set<VariableExpr> tmpCurrentGroupingSetVars = new LinkedHashSet<VariableExpr>();

    public SqlppGroupingSetsVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectSetOperation setOp, ILangExpression arg) throws CompilationException {
        super.visit(setOp, arg);
        SetOperationInput setOpInputLeft = setOp.getLeftInput();
        SelectBlock selectBlockLeft = setOpInputLeft.getSelectBlock();
        if (selectBlockLeft != null && selectBlockLeft.hasGroupbyClause()) {
            SelectExpression selectExpression = (SelectExpression)arg;
            boolean hasPostSetOpClauses = selectExpression.hasOrderby() || selectExpression.hasLimit();
            Map<VariableExpr, String> extraProjections = Collections.emptyMap();
            if (hasPostSetOpClauses && !setOp.hasRightInputs() && this.isMultiGroupingSets(selectBlockLeft)) {
                extraProjections = this.rewritePostSetOpClauses(selectExpression, selectBlockLeft);
            }
            SelectBlock newSelectBlockLeft = this.rewriteSelectBlock(selectBlockLeft, extraProjections);
            setOpInputLeft.setSelectBlock(newSelectBlockLeft);
        }
        if (setOp.hasRightInputs()) {
            for (SetOperationRight setOpRight : setOp.getRightInputs()) {
                SetOperationInput setOpInputRight = setOpRight.getSetOperationRightInput();
                SelectBlock selectBlockRight = setOpInputRight.getSelectBlock();
                if (selectBlockRight == null || !selectBlockRight.hasGroupbyClause()) continue;
                SelectBlock newSelectBlockRight = this.rewriteSelectBlock(selectBlockRight, Collections.emptyMap());
                setOpInputRight.setSelectBlock(newSelectBlockRight);
            }
        }
        return null;
    }

    private Map<VariableExpr, String> rewritePostSetOpClauses(SelectExpression selectExpression, SelectBlock selectBlockLeft) throws CompilationException {
        Set<VariableExpr> freeVarsPostSetOp = this.getFreeVarsPostSetOp(selectExpression);
        if (freeVarsPostSetOp.isEmpty()) {
            return Collections.emptyMap();
        }
        Pair<Map<VariableExpr, VariableExpr>, Map<VariableExpr, String>> p = this.computePostSetOpSubstMap(selectBlockLeft, freeVarsPostSetOp);
        Map freeVarsPostSetOpSubstMap = (Map)p.first;
        Map extraProjections = (Map)p.second;
        SqlppSubstituteExpressionVisitor substVisitor = new SqlppSubstituteExpressionVisitor(this.context, freeVarsPostSetOpSubstMap);
        if (selectExpression.hasOrderby()) {
            selectExpression.getOrderbyClause().accept((ILangVisitor)substVisitor, (Object)selectExpression);
        }
        if (selectExpression.hasLimit()) {
            selectExpression.getLimitClause().accept((ILangVisitor)substVisitor, (Object)selectExpression);
        }
        return extraProjections;
    }

    private Pair<Map<VariableExpr, VariableExpr>, Map<VariableExpr, String>> computePostSetOpSubstMap(SelectBlock selectBlockLeft, Set<VariableExpr> freeVarsPostSetOp) throws CompilationException {
        SelectClause selectClause = selectBlockLeft.getSelectClause();
        if (selectClause.selectRegular()) {
            return this.computePostSetOpSubstMapForSelectRegular(freeVarsPostSetOp, selectBlockLeft);
        }
        if (selectClause.selectElement()) {
            return this.computePostSetOpSubstMapForSelectElement(freeVarsPostSetOp);
        }
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, selectBlockLeft.getSourceLocation(), new Serializable[]{""});
    }

    private Pair<Map<VariableExpr, VariableExpr>, Map<VariableExpr, String>> computePostSetOpSubstMapForSelectRegular(Set<VariableExpr> freeVarsPostSetOp, SelectBlock selectBlock) throws CompilationException {
        Map<VariableExpr, String> extraProjections = Collections.emptyMap();
        HashMap<VariableExpr, VariableExpr> freeVarsPostSetOpSubstMap = new HashMap<VariableExpr, VariableExpr>();
        List<Projection> projectionList = selectBlock.getSelectClause().getSelectRegular().getProjections();
        List<VariableExpr> gbyBindingVars = null;
        List postGbyBindingVars = null;
        for (VariableExpr freeVarPostSetOp : freeVarsPostSetOp) {
            String projectionName = null;
            for (int i = projectionList.size() - 1; i >= 0; --i) {
                Projection projection = projectionList.get(i);
                if (projection.varStar()) {
                    throw new CompilationException(ErrorCode.UNSUPPORTED_GBY_OBY_SELECT_COMBO, selectBlock.getSourceLocation(), new Serializable[0]);
                }
                if (projection.star()) {
                    if (gbyBindingVars == null) {
                        gbyBindingVars = SqlppVariableUtil.getBindingVariables(selectBlock.getGroupbyClause());
                    }
                    if (postGbyBindingVars == null) {
                        List<Object> list = postGbyBindingVars = selectBlock.hasLetHavingClausesAfterGroupby() ? SqlppVariableUtil.getLetBindingVariables(selectBlock.getLetHavingListAfterGroupby()) : Collections.emptyList();
                    }
                    if (!gbyBindingVars.contains(freeVarPostSetOp) && !postGbyBindingVars.contains(freeVarPostSetOp)) continue;
                    projectionName = SqlppVariableUtil.variableNameToDisplayedFieldName(freeVarPostSetOp.getVar().getValue());
                    break;
                }
                if (projection.hasName()) {
                    if (!projection.getExpression().equals(freeVarPostSetOp)) continue;
                    projectionName = projection.getName();
                    break;
                }
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, selectBlock.getSourceLocation(), new Serializable[]{""});
            }
            boolean newProjection = false;
            if (projectionName == null) {
                newProjection = true;
                projectionName = this.generateProjectionName(projectionList);
            }
            VariableExpr substExpr = new VariableExpr(SqlppVariableUtil.toInternalVariableIdentifier(projectionName));
            substExpr.setSourceLocation(freeVarPostSetOp.getSourceLocation());
            freeVarsPostSetOpSubstMap.put(freeVarPostSetOp, substExpr);
            if (!newProjection) continue;
            if (extraProjections.isEmpty()) {
                extraProjections = new LinkedHashMap();
            }
            extraProjections.put(freeVarPostSetOp, projectionName);
        }
        return new Pair(freeVarsPostSetOpSubstMap, extraProjections);
    }

    private Pair<Map<VariableExpr, VariableExpr>, Map<VariableExpr, String>> computePostSetOpSubstMapForSelectElement(Set<VariableExpr> freeVarsPostSetOp) {
        HashMap<VariableExpr, VariableExpr> freeVarsPostSetOpSubstMap = new HashMap<VariableExpr, VariableExpr>();
        LinkedHashMap<VariableExpr, String> extraProjections = new LinkedHashMap<VariableExpr, String>();
        for (VariableExpr freeVarPostSelect : freeVarsPostSetOp) {
            String projectionName = SqlppVariableUtil.variableNameToDisplayedFieldName(this.context.newVariable().getValue());
            VariableExpr substExpr = new VariableExpr(SqlppVariableUtil.toInternalVariableIdentifier(projectionName));
            substExpr.setSourceLocation(freeVarPostSelect.getSourceLocation());
            freeVarsPostSetOpSubstMap.put(freeVarPostSelect, substExpr);
            extraProjections.put(freeVarPostSelect, projectionName);
        }
        return new Pair(freeVarsPostSetOpSubstMap, extraProjections);
    }

    private Set<VariableExpr> getFreeVarsPostSetOp(SelectExpression selectExpression) throws CompilationException {
        if (selectExpression.hasOrderby() || selectExpression.hasLimit()) {
            ListSet freeVars = new ListSet();
            FreeVariableVisitor freeVarsVisitor = new FreeVariableVisitor();
            if (selectExpression.hasOrderby()) {
                selectExpression.getOrderbyClause().accept((ILangVisitor)freeVarsVisitor, (Object)freeVars);
            }
            if (selectExpression.hasLimit()) {
                selectExpression.getLimitClause().accept((ILangVisitor)freeVarsVisitor, (Object)freeVars);
            }
            return freeVars;
        }
        return Collections.emptySet();
    }

    private boolean isMultiGroupingSets(SelectBlock selectBlock) {
        return selectBlock.getGroupbyClause().getGbyPairList().size() > 1;
    }

    private SelectBlock rewriteSelectBlock(SelectBlock selectBlock, Map<VariableExpr, String> extraProjections) throws CompilationException {
        if (this.isMultiGroupingSets(selectBlock)) {
            return this.rewriteMultipleGroupingSets(selectBlock, extraProjections);
        }
        if (!extraProjections.isEmpty()) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, selectBlock.getSourceLocation(), new Serializable[]{extraProjections.toString()});
        }
        return this.rewriteZeroOrOneGroupingSet(selectBlock);
    }

    private SelectBlock rewriteZeroOrOneGroupingSet(SelectBlock selectBlock) throws CompilationException {
        GroupbyClause gby = selectBlock.getGroupbyClause();
        List groupingSets = gby.getGbyPairList();
        if (groupingSets.size() > 1) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, gby.getSourceLocation(), new Serializable[]{""});
        }
        this.tmpAllGroupingSetsVars.clear();
        SqlppGroupingSetsVisitor.getAllGroupingSetsVars(groupingSets, this.tmpAllGroupingSetsVars);
        SqlppGroupingSetsVisitor.rewriteGroupingOperations(selectBlock, this.tmpAllGroupingSetsVars, this.tmpAllGroupingSetsVars);
        return selectBlock;
    }

    private SelectBlock rewriteMultipleGroupingSets(SelectBlock selectBlock, Map<VariableExpr, String> extraProjections) throws CompilationException {
        GroupbyClause gby = selectBlock.getGroupbyClause();
        List groupingSets = gby.getGbyPairList();
        int nGroupingSets = groupingSets.size();
        if (nGroupingSets <= 1 || !gby.getDecorPairList().isEmpty()) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, gby.getSourceLocation(), new Serializable[]{""});
        }
        SelectClause selectClause = selectBlock.getSelectClause();
        boolean distinct = selectClause.distinct();
        boolean selectElement = selectClause.selectElement();
        boolean selectElementConvertToRegular = selectElement && !extraProjections.isEmpty();
        String selectElementMainProjectionName = selectElementConvertToRegular ? SqlppVariableUtil.variableNameToDisplayedFieldName(this.context.newVariable().getValue()) : null;
        this.tmpAllGroupingSetsVars.clear();
        SqlppGroupingSetsVisitor.getAllGroupingSetsVars(groupingSets, this.tmpAllGroupingSetsVars);
        ArrayList<SetOperationRight> newSetOpRightInputs = new ArrayList<SetOperationRight>(nGroupingSets - 1);
        for (int i = 1; i < nGroupingSets; ++i) {
            List groupingSet = (List)groupingSets.get(i);
            this.tmpCurrentGroupingSetVars.clear();
            SqlppGroupingSetsVisitor.getGroupingSetVars(groupingSet, this.tmpCurrentGroupingSetVars);
            this.tmpGroupingSets.clear();
            this.tmpGroupingSets.add(groupingSet);
            gby.setGbyPairList(this.tmpGroupingSets);
            this.tmpDecorPairList.clear();
            SqlppGroupingSetsVisitor.computeDecorVars(this.tmpCurrentGroupingSetVars, this.tmpAllGroupingSetsVars, this.tmpDecorPairList);
            gby.setDecorPairList(this.tmpDecorPairList);
            SelectBlock newSelectBlock = (SelectBlock)SqlppRewriteUtil.deepCopy((ILangExpression)selectBlock);
            SqlppGroupingSetsVisitor.rewriteGroupingOperations(newSelectBlock, this.tmpCurrentGroupingSetVars, this.tmpAllGroupingSetsVars);
            SqlppGroupingSetsVisitor.rewriteSelectClause(newSelectBlock, extraProjections, selectElementMainProjectionName);
            SetOperationRight newSetOpRight = new SetOperationRight(SetOpType.UNION, false, new SetOperationInput(newSelectBlock, null));
            newSetOpRightInputs.add(newSetOpRight);
        }
        List groupingSet = (List)groupingSets.get(0);
        gby.setGbyPairList(Collections.singletonList(groupingSet));
        this.tmpCurrentGroupingSetVars.clear();
        SqlppGroupingSetsVisitor.getGroupingSetVars(groupingSet, this.tmpCurrentGroupingSetVars);
        ArrayList<GbyVariableExpressionPair> newDecorPairList = new ArrayList<GbyVariableExpressionPair>();
        SqlppGroupingSetsVisitor.computeDecorVars(this.tmpCurrentGroupingSetVars, this.tmpAllGroupingSetsVars, newDecorPairList);
        gby.setDecorPairList(newDecorPairList);
        SqlppGroupingSetsVisitor.rewriteGroupingOperations(selectBlock, this.tmpCurrentGroupingSetVars, this.tmpAllGroupingSetsVars);
        SqlppGroupingSetsVisitor.rewriteSelectClause(selectBlock, extraProjections, selectElementMainProjectionName);
        SetOperationInput newSetOpInput = new SetOperationInput(selectBlock, null);
        SelectSetOperation newSetOp = new SelectSetOperation(newSetOpInput, newSetOpRightInputs);
        newSetOp.setSourceLocation(selectBlock.getSourceLocation());
        SelectExpression newSelectExpr = new SelectExpression(null, newSetOp, null, null, true);
        newSelectExpr.setSourceLocation(selectBlock.getSourceLocation());
        return selectElement ? SetOperationVisitor.createSelectBlock((Expression)newSelectExpr, distinct, selectElementConvertToRegular ? SqlppRewriteUtil::getFieldByName : null, selectElementConvertToRegular ? selectElementMainProjectionName : null, this.context) : SetOperationVisitor.createSelectBlock((Expression)newSelectExpr, distinct, SqlppGroupingSetsVisitor::removeFieldsByName, extraProjections.values(), this.context);
    }

    private static void rewriteSelectClause(SelectBlock selectBlock, Map<VariableExpr, String> extraProjections, String selectElementMainProjectionName) throws CompilationException {
        SelectClause selectClause = selectBlock.getSelectClause();
        selectClause.setDistinct(false);
        if (!extraProjections.isEmpty()) {
            if (selectClause.selectElement()) {
                selectClause = SqlppGroupingSetsVisitor.convertSelectElementToRegular(selectClause, selectElementMainProjectionName);
            }
            SqlppGroupingSetsVisitor.insertExtraProjections(selectClause, extraProjections);
        }
        selectBlock.setSelectClause(selectClause);
    }

    private static SelectClause convertSelectElementToRegular(SelectClause selectClause, String mainProjectionName) throws CompilationException {
        if (!selectClause.selectElement() || selectClause.distinct()) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, selectClause.getSourceLocation(), new Serializable[]{""});
        }
        SelectElement selectElement = selectClause.getSelectElement();
        ArrayList<Projection> projectionList = new ArrayList<Projection>(1);
        projectionList.add(new Projection(selectElement.getExpression(), mainProjectionName, false, false));
        SelectRegular newSelectRegular = new SelectRegular(projectionList);
        newSelectRegular.setSourceLocation(selectElement.getSourceLocation());
        SelectClause newSelectClause = new SelectClause(null, newSelectRegular, selectClause.distinct());
        newSelectClause.setSourceLocation(selectClause.getSourceLocation());
        return newSelectClause;
    }

    private static void insertExtraProjections(SelectClause selectClause, Map<VariableExpr, String> projections) throws CompilationException {
        if (!selectClause.selectRegular()) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, selectClause.getSourceLocation(), new Serializable[]{""});
        }
        SelectRegular selectRegular = selectClause.getSelectRegular();
        for (Map.Entry<VariableExpr, String> me : projections.entrySet()) {
            Projection newProjection = new Projection((Expression)((VariableExpr)SqlppRewriteUtil.deepCopy((ILangExpression)me.getKey())), me.getValue(), false, false);
            selectRegular.getProjections().add(newProjection);
        }
    }

    private static Expression removeFieldsByName(Expression inExpr, Collection<String> fieldNames) {
        Expression resultExpr = inExpr;
        for (String fieldName : fieldNames) {
            LiteralExpr fieldNameExpr = new LiteralExpr((Literal)new StringLiteral(fieldName));
            fieldNameExpr.setSourceLocation(resultExpr.getSourceLocation());
            ArrayList<Object> argList = new ArrayList<Object>(2);
            argList.add(resultExpr);
            argList.add(fieldNameExpr);
            CallExpr callExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.RECORD_REMOVE), argList);
            callExpr.setSourceLocation(resultExpr.getSourceLocation());
            resultExpr = callExpr;
        }
        return resultExpr;
    }

    private String generateProjectionName(List<Projection> projectionList) {
        String projectionName;
        while (SqlppGroupingSetsVisitor.findProjectionByName(projectionList, projectionName = SqlppVariableUtil.variableNameToDisplayedFieldName(this.context.newVariable().getValue())) != null) {
        }
        return projectionName;
    }

    private static Projection findProjectionByName(List<Projection> projectionList, String name) {
        for (Projection projection : projectionList) {
            if (!projection.hasName() || !projection.getName().equals(name)) continue;
            return projection;
        }
        return null;
    }

    private static void rewriteGroupingOperations(SelectBlock selectBlock, Set<VariableExpr> currentGroupingSetVars, Set<VariableExpr> allGroupingSetsVars) throws CompilationException {
        if (selectBlock.hasLetHavingClausesAfterGroupby()) {
            for (Clause clause : selectBlock.getLetHavingListAfterGroupby()) {
                LetClause letClause;
                Expression letExpr;
                if (clause.getClauseType() != Clause.ClauseType.LET_CLAUSE || !SqlppGroupByVisitor.isGroupingOperation(letExpr = (letClause = (LetClause)clause).getBindingExpr())) continue;
                Expression newLetExpr = SqlppGroupingSetsVisitor.rewriteGroupingOperation((CallExpr)letExpr, currentGroupingSetVars, allGroupingSetsVars);
                letClause.setBindingExpr(newLetExpr);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Expression rewriteGroupingOperation(CallExpr callExpr, Set<VariableExpr> currentGroupingSetVars, Set<VariableExpr> allGroupingSetsVars) throws CompilationException {
        List argList = callExpr.getExprList();
        if (argList.isEmpty()) {
            throw new CompilationException(ErrorCode.COMPILATION_INVALID_NUM_OF_ARGS, callExpr.getSourceLocation(), new Serializable[]{BuiltinFunctions.GROUPING.getName()});
        }
        if (callExpr.hasAggregateFilterExpr()) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_USE_OF_FILTER_CLAUSE, callExpr.getSourceLocation(), new Serializable[0]);
        }
        long result = 0L;
        for (Expression argExpr : argList) {
            int v;
            if (argExpr.getKind() != Expression.Kind.VARIABLE_EXPRESSION) throw new CompilationException(ErrorCode.COMPILATION_GROUPING_OPERATION_INVALID_ARG, argExpr.getSourceLocation(), new Serializable[0]);
            VariableExpr varExpr = (VariableExpr)argExpr;
            if (currentGroupingSetVars.contains(varExpr)) {
                v = 0;
            } else {
                if (!allGroupingSetsVars.contains(varExpr)) throw new CompilationException(ErrorCode.COMPILATION_GROUPING_OPERATION_INVALID_ARG, argExpr.getSourceLocation(), new Serializable[0]);
                v = 1;
            }
            result = (result << 1) + (long)v;
        }
        LiteralExpr resultExpr = new LiteralExpr((Literal)new LongIntegerLiteral(Long.valueOf(result)));
        resultExpr.setSourceLocation(callExpr.getSourceLocation());
        return resultExpr;
    }

    private static void getAllGroupingSetsVars(List<List<GbyVariableExpressionPair>> gbyList, Set<VariableExpr> outVars) {
        for (List<GbyVariableExpressionPair> gbyPairList : gbyList) {
            SqlppGroupingSetsVisitor.getGroupingSetVars(gbyPairList, outVars);
        }
    }

    private static void getGroupingSetVars(List<GbyVariableExpressionPair> groupingSet, Collection<VariableExpr> outVars) {
        for (GbyVariableExpressionPair gbyPair : groupingSet) {
            outVars.add(gbyPair.getVar());
        }
    }

    private static void computeDecorVars(Set<VariableExpr> currentGroupingSetVars, Set<VariableExpr> allGroupingSetsVars, List<GbyVariableExpressionPair> outDecorPairList) {
        for (VariableExpr var : allGroupingSetsVars) {
            if (currentGroupingSetVars.contains(var)) continue;
            LiteralExpr nullExpr = new LiteralExpr((Literal)NullLiteral.INSTANCE);
            nullExpr.setSourceLocation(var.getSourceLocation());
            VariableExpr newDecorVarExpr = new VariableExpr(var.getVar());
            newDecorVarExpr.setSourceLocation(var.getSourceLocation());
            outDecorPairList.add(new GbyVariableExpressionPair(newDecorVarExpr, (Expression)nullExpr));
        }
    }
}

