/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class ConcatTypeComputer
extends AbstractResultTypeComputer {
    public static final ConcatTypeComputer INSTANCE_STRING = new ConcatTypeComputer(BuiltinType.ASTRING);
    public static final ConcatTypeComputer INSTANCE_BINARY = new ConcatTypeComputer(BuiltinType.ABINARY);
    private final IAType resultType;

    private ConcatTypeComputer(IAType resultType) {
        this.resultType = resultType;
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType argType = strippedInputTypes[0];
        IAType outputType = this.resultType;
        if (!argType.getTypeTag().isListType() || ((AbstractCollectionType)argType).getItemType().getTypeTag() != outputType.getTypeTag()) {
            outputType = AUnionType.createUnknownableType(outputType);
        }
        return outputType;
    }
}

