/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class GetRecordFieldValueEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory recordEvalFactory;
    private IScalarEvaluatorFactory fldNameEvalFactory;
    private final ARecordType recordType;
    private final SourceLocation sourceLoc;

    public GetRecordFieldValueEvalFactory(IScalarEvaluatorFactory recordEvalFactory, IScalarEvaluatorFactory fldNameEvalFactory, ARecordType recordType, SourceLocation sourceLoc) {
        this.recordEvalFactory = recordEvalFactory;
        this.fldNameEvalFactory = fldNameEvalFactory;
        this.recordType = recordType;
        this.sourceLoc = sourceLoc;
    }

    public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
        return new IScalarEvaluator(){
            private final IBinaryHashFunction fieldNameHashFunction = BinaryHashFunctionFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryHashFunction();
            private final IBinaryComparator fieldNameComparator = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
            private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
            private final DataOutput out = this.resultStorage.getDataOutput();
            private final IPointable inputArg0 = new VoidPointable();
            private final IPointable inputArg1 = new VoidPointable();
            private final IScalarEvaluator recordEval;
            private final IScalarEvaluator fieldNameEval;
            private final RuntimeRecordTypeInfo recTypeInfo;
            {
                this.recordEval = GetRecordFieldValueEvalFactory.this.recordEvalFactory.createScalarEvaluator(ctx);
                this.fieldNameEval = GetRecordFieldValueEvalFactory.this.fldNameEvalFactory.createScalarEvaluator(ctx);
                this.recTypeInfo = new RuntimeRecordTypeInfo();
                this.recTypeInfo.reset(GetRecordFieldValueEvalFactory.this.recordType);
            }

            public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                try {
                    this.resultStorage.reset();
                    this.recordEval.evaluate(tuple, this.inputArg0);
                    this.fieldNameEval.evaluate(tuple, this.inputArg1);
                    if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg0, this.inputArg1)) {
                        return;
                    }
                    byte[] serFldName = this.inputArg1.getByteArray();
                    int serFldNameOffset = this.inputArg1.getStartOffset();
                    int serFldNameLen = this.inputArg1.getLength();
                    if (serFldName[serFldNameOffset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                        throw new TypeMismatchException(GetRecordFieldValueEvalFactory.this.sourceLoc, BuiltinFunctions.GET_RECORD_FIELD_VALUE, 0, serFldName[serFldNameOffset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                    }
                    byte[] serRecord = this.inputArg0.getByteArray();
                    int serRecordOffset = this.inputArg0.getStartOffset();
                    int serRecordLen = this.inputArg0.getLength();
                    if (serRecord[serRecordOffset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                        throw new TypeMismatchException(GetRecordFieldValueEvalFactory.this.sourceLoc, BuiltinFunctions.GET_RECORD_FIELD_VALUE, 0, serRecord[serRecordOffset], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                    }
                    int subFieldOffset = -1;
                    int subFieldLength = -1;
                    int subFieldIndex = this.recTypeInfo.getFieldIndex(serFldName, serFldNameOffset + 1, serFldNameLen - 1);
                    if (subFieldIndex >= 0) {
                        int nullBitmapSize = RecordUtil.computeNullBitmapSize((ARecordType)GetRecordFieldValueEvalFactory.this.recordType);
                        subFieldOffset = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serRecord, (int)serRecordOffset, (int)subFieldIndex, (int)nullBitmapSize, (boolean)GetRecordFieldValueEvalFactory.this.recordType.isOpen());
                        switch (subFieldOffset) {
                            case -1: {
                                this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                            case 0: {
                                this.out.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                        }
                        IAType fieldType = GetRecordFieldValueEvalFactory.this.recordType.getFieldTypes()[subFieldIndex];
                        if (fieldType.getTypeTag() == ATypeTag.UNION) {
                            fieldType = ((AUnionType)fieldType).getActualType();
                        }
                        ATypeTag fieldTypeTag = fieldType.getTypeTag();
                        subFieldLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)subFieldOffset, (ATypeTag)fieldTypeTag, (boolean)false);
                        this.out.writeByte(fieldTypeTag.serialize());
                        this.out.write(serRecord, subFieldOffset, subFieldLength);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    subFieldOffset = ARecordSerializerDeserializer.getFieldOffsetByName((byte[])serRecord, (int)serRecordOffset, (int)serRecordLen, (byte[])serFldName, (int)serFldNameOffset, (IBinaryHashFunction)this.fieldNameHashFunction, (IBinaryComparator)this.fieldNameComparator);
                    if (subFieldOffset < 0) {
                        this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    ATypeTag fieldValueTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serRecord[subFieldOffset]);
                    subFieldLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)subFieldOffset, (ATypeTag)fieldValueTypeTag, (boolean)true) + 1;
                    result.set(serRecord, subFieldOffset, subFieldLength);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

