/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.dataflow.NoOpFrameOperationCallbackFactory;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.PrimaryIndexLogMarkerCallback;
import org.apache.asterix.transaction.management.opcallbacks.LockThenSearchOperationCallback;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameTupleProcessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMPrimaryInsertOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    private final IIndexDataflowHelper keyIndexHelper;
    private MultiComparator keySearchCmp;
    private RangePredicate searchPred;
    private IIndexCursor cursor;
    private LockThenSearchOperationCallback searchCallback;
    private final ISearchOperationCallbackFactory searchCallbackFactory;
    private final IFrameTupleProcessor processor;
    private LSMTreeIndexAccessor lsmAccessor;
    private LSMTreeIndexAccessor lsmAccessorForKeyIndex;
    private LSMTreeIndexAccessor lsmAccessorForUniqunessCheck;
    private final IFrameOperationCallback frameOpCallback;
    private boolean flushedPartialTuples;
    private int currentTupleIdx;
    private int lastFlushedTupleIdx;
    private final PermutingFrameTupleReference keyTuple;

    public LSMPrimaryInsertOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, IIndexDataflowHelperFactory keyIndexHelperFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, IModificationOperationCallbackFactory modCallbackFactory, ISearchOperationCallbackFactory searchCallbackFactory, int numOfPrimaryKeys, int[] filterFields, SourceLocation sourceLoc) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, IndexOperation.UPSERT, modCallbackFactory, null);
        int i;
        this.keyIndexHelper = keyIndexHelperFactory != null ? keyIndexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition) : null;
        this.searchCallbackFactory = searchCallbackFactory;
        int numFilterFieds = filterFields != null ? filterFields.length : 0;
        int[] searchKeyPermutations = new int[numOfPrimaryKeys + numFilterFieds];
        for (i = 0; i < numOfPrimaryKeys; ++i) {
            searchKeyPermutations[i] = fieldPermutation[i];
        }
        if (filterFields != null) {
            for (i = numOfPrimaryKeys; i < searchKeyPermutations.length; ++i) {
                searchKeyPermutations[i] = filterFields[i - numOfPrimaryKeys];
            }
        }
        this.keyTuple = new PermutingFrameTupleReference(searchKeyPermutations);
        this.processor = this.createTupleProcessor(sourceLoc);
        this.frameOpCallback = NoOpFrameOperationCallbackFactory.INSTANCE.createFrameOperationCallback(ctx, (ILSMIndexAccessor)this.lsmAccessor);
    }

    protected void beforeModification(ITupleReference tuple) {
    }

    protected IFrameTupleProcessor createTupleProcessor(final SourceLocation sourceLoc) {
        return new IFrameTupleProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(ITupleReference tuple, int index) throws HyracksDataException {
                if (index < LSMPrimaryInsertOperatorNodePushable.this.currentTupleIdx) {
                    return;
                }
                LSMPrimaryInsertOperatorNodePushable.this.keyTuple.reset((IFrameTupleAccessor)LSMPrimaryInsertOperatorNodePushable.this.accessor, index);
                LSMPrimaryInsertOperatorNodePushable.this.searchPred.reset((ITupleReference)LSMPrimaryInsertOperatorNodePushable.this.keyTuple, (ITupleReference)LSMPrimaryInsertOperatorNodePushable.this.keyTuple, true, true, LSMPrimaryInsertOperatorNodePushable.this.keySearchCmp, LSMPrimaryInsertOperatorNodePushable.this.keySearchCmp);
                boolean duplicate = false;
                LSMPrimaryInsertOperatorNodePushable.this.lsmAccessorForUniqunessCheck.search(LSMPrimaryInsertOperatorNodePushable.this.cursor, (ISearchPredicate)LSMPrimaryInsertOperatorNodePushable.this.searchPred);
                try {
                    if (LSMPrimaryInsertOperatorNodePushable.this.cursor.hasNext()) {
                        LSMPrimaryInsertOperatorNodePushable.this.searchCallback.release();
                        duplicate = true;
                    }
                }
                finally {
                    LSMPrimaryInsertOperatorNodePushable.this.cursor.close();
                }
                if (!duplicate) {
                    LSMPrimaryInsertOperatorNodePushable.this.beforeModification(tuple);
                    LSMPrimaryInsertOperatorNodePushable.this.lsmAccessor.forceUpsert(tuple);
                    if (LSMPrimaryInsertOperatorNodePushable.this.lsmAccessorForKeyIndex != null) {
                        LSMPrimaryInsertOperatorNodePushable.this.lsmAccessorForKeyIndex.forceUpsert((ITupleReference)LSMPrimaryInsertOperatorNodePushable.this.keyTuple);
                    }
                } else {
                    LSMPrimaryInsertOperatorNodePushable.this.flushPartialFrame();
                    throw HyracksDataException.create((ErrorCode)ErrorCode.ERROR_PROCESSING_TUPLE, (Throwable)HyracksDataException.create((ErrorCode)ErrorCode.DUPLICATE_KEY, (Serializable[])new Serializable[0]), (SourceLocation)sourceLoc, (Serializable[])new Serializable[]{Integer.valueOf(index)});
                }
                LSMPrimaryInsertOperatorNodePushable.this.currentTupleIdx = index + 1;
            }

            public void start() throws HyracksDataException {
                LSMPrimaryInsertOperatorNodePushable.this.lsmAccessor.getCtx().setOperation(IndexOperation.UPSERT);
            }

            public void finish() throws HyracksDataException {
                LSMPrimaryInsertOperatorNodePushable.this.lsmAccessor.getCtx().setOperation(IndexOperation.UPSERT);
            }

            public void fail(Throwable th) {
            }
        };
    }

    public void open() throws HyracksDataException {
        IIndex indexForUniquessCheck;
        this.currentTupleIdx = 0;
        this.lastFlushedTupleIdx = 0;
        this.flushedPartialTuples = false;
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        if (this.keyIndexHelper != null) {
            this.keyIndexHelper.open();
            indexForUniquessCheck = this.keyIndexHelper.getIndexInstance();
        } else {
            indexForUniquessCheck = this.index;
        }
        try {
            if (this.ctx.getSharedObject() != null) {
                PrimaryIndexLogMarkerCallback callback = new PrimaryIndexLogMarkerCallback((ILSMIndex)((AbstractLSMIndex)this.index));
                TaskUtil.put((String)"MARKER_CALLBACK", (Object)callback, (IHyracksTaskContext)this.ctx);
            }
            this.frameOpCallback.open();
            this.writer.open();
            this.keySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])((ITreeIndex)this.index).getComparatorFactories(), (ITupleReference)this.frameTuple);
            this.searchPred = new RangePredicate((ITupleReference)this.frameTuple, (ITupleReference)this.frameTuple, true, true, this.keySearchCmp, this.keySearchCmp, null, null);
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
            this.modCallback = this.modOpCallbackFactory.createModificationOperationCallback(this.indexHelper.getResource(), this.ctx, (IOperatorNodePushable)this);
            this.searchCallback = (LockThenSearchOperationCallback)this.searchCallbackFactory.createSearchOperationCallback(this.indexHelper.getResource().getId(), this.ctx, (IOperatorNodePushable)this);
            IndexAccessParameters iap = new IndexAccessParameters(this.modCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.indexAccessor = this.index.createAccessor((IIndexAccessParameters)iap);
            this.lsmAccessor = (LSMTreeIndexAccessor)this.indexAccessor;
            if (this.keyIndexHelper != null) {
                this.lsmAccessorForKeyIndex = (LSMTreeIndexAccessor)indexForUniquessCheck.createAccessor((IIndexAccessParameters)iap);
            }
            IndexAccessParameters iapForUniquenessCheck = new IndexAccessParameters((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)this.searchCallback);
            this.lsmAccessorForUniqunessCheck = (LSMTreeIndexAccessor)indexForUniquessCheck.createAccessor((IIndexAccessParameters)iapForUniquenessCheck);
            this.cursor = this.lsmAccessorForUniqunessCheck.createSearchCursor(false);
            this.frameTuple = new FrameTupleReference();
            INcApplicationContext appCtx = (INcApplicationContext)this.ctx.getJobletContext().getServiceContext().getApplicationContext();
            LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)this.index), (ILogManager)appCtx.getTransactionSubsystem().getLogManager());
        }
        catch (Throwable e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        this.lsmAccessor.batchOperate(this.accessor, (FrameTupleReference)this.tuple, this.processor, this.frameOpCallback);
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        if (this.flushedPartialTuples) {
            this.flushPartialFrame();
        } else {
            FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
            FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
        }
        this.currentTupleIdx = 0;
        this.lastFlushedTupleIdx = 0;
        this.flushedPartialTuples = false;
    }

    public void flushPartialFrame() throws HyracksDataException {
        if (this.lastFlushedTupleIdx == this.currentTupleIdx) {
            return;
        }
        for (int i = this.lastFlushedTupleIdx; i < this.currentTupleIdx; ++i) {
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessor, (int)i);
        }
        this.appender.write(this.writer, true);
        this.lastFlushedTupleIdx = this.currentTupleIdx;
        this.flushedPartialTuples = true;
    }

    public void close() throws HyracksDataException {
        Throwable failure = CleanupUtils.destroy(null, (IDestroyable[])new IDestroyable[]{this.cursor});
        failure = CleanupUtils.close((IFrameWriter)this.writer, (Throwable)failure);
        failure = CleanupUtils.close((AutoCloseable)this.indexHelper, (Throwable)failure);
        if ((failure = CleanupUtils.close((AutoCloseable)this.keyIndexHelper, (Throwable)failure)) != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void flush() throws HyracksDataException {
    }
}

