/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.common.config.ConfigUtils;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String NODE_ID_KEY = "node_id";
    protected static final String CONFIG_URI_KEY = "configUri";
    protected static final String STATS_URI_KEY = "statsUri";
    protected static final String THREAD_DUMP_URI_KEY = "threadDumpUri";
    protected static final String SHUTDOWN_URI_KEY = "shutdownUri";
    protected static final String FULL_SHUTDOWN_URI_KEY = "fullShutdownUri";
    protected static final String VERSION_URI_KEY = "versionUri";
    protected static final String DIAGNOSTICS_URI_KEY = "diagnosticsUri";
    protected final ICcApplicationContext appCtx;

    public ClusterApiServlet(ICcApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String ... paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
        PrintWriter responseWriter = response.writer();
        try {
            ObjectNode json;
            response.setStatus(HttpResponseStatus.OK);
            switch (this.localPath(request)) {
                case "": {
                    json = this.getClusterStateJSON(request, "");
                    break;
                }
                case "/summary": {
                    json = this.getClusterStateSummaryJSON();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            JSONUtil.writeNode((Writer)responseWriter, (JsonNode)json);
        }
        catch (IllegalArgumentException e) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception thrown for " + request, (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            responseWriter.write(e.toString());
        }
        responseWriter.flush();
    }

    protected void post(IServletRequest request, IServletResponse response) throws Exception {
        switch (this.localPath(request)) {
            case "/partition/master": {
                this.processPartitionMaster(request, response);
                break;
            }
            case "/metadataNode": {
                this.processMetadataNode(request, response);
                break;
            }
            default: {
                this.sendError(response, HttpResponseStatus.NOT_FOUND);
            }
        }
    }

    protected ObjectNode getClusterStateSummaryJSON() {
        return this.appCtx.getClusterStateManager().getClusterStateSummary();
    }

    protected ObjectNode getClusterStateJSON(IServletRequest request, String pathToNode) {
        ObjectNode cc;
        ObjectNode json = this.appCtx.getClusterStateManager().getClusterStateDescription();
        ICcApplicationContext appConfig = (ICcApplicationContext)this.ctx.get("org.apache.asterix.APP_CONTEXT_INFO");
        json.putPOJO("config", (Object)ConfigUtils.getSectionOptionsForJSON((IApplicationConfig)appConfig.getServiceContext().getAppConfig(), (Section)Section.COMMON, this.getConfigSelector()));
        ArrayNode ncs = (ArrayNode)json.get("ncs");
        String clusterURL = this.resolveClusterUrl(request, pathToNode);
        String adminURL = HttpUtil.canonicalize((CharSequence)(clusterURL + "../"));
        String nodeURL = clusterURL + "node/";
        for (int i = 0; i < ncs.size(); ++i) {
            ObjectNode nc = (ObjectNode)ncs.get(i);
            nc.put(CONFIG_URI_KEY, nodeURL + nc.get(NODE_ID_KEY).asText() + "/config");
            nc.put(STATS_URI_KEY, nodeURL + nc.get(NODE_ID_KEY).asText() + "/stats");
            nc.put(THREAD_DUMP_URI_KEY, nodeURL + nc.get(NODE_ID_KEY).asText() + "/threaddump");
        }
        if (json.has("cc")) {
            cc = (ObjectNode)json.get("cc");
        } else {
            cc = OBJECT_MAPPER.createObjectNode();
            json.set("cc", (JsonNode)cc);
        }
        cc.put(CONFIG_URI_KEY, clusterURL + "cc/config");
        cc.put(STATS_URI_KEY, clusterURL + "cc/stats");
        cc.put(THREAD_DUMP_URI_KEY, clusterURL + "cc/threaddump");
        json.put(SHUTDOWN_URI_KEY, adminURL + "shutdown");
        json.put(FULL_SHUTDOWN_URI_KEY, adminURL + "shutdown?all=true");
        json.put(VERSION_URI_KEY, adminURL + "version");
        json.put(DIAGNOSTICS_URI_KEY, adminURL + "diagnostics");
        return json;
    }

    protected String resolveClusterUrl(IServletRequest request, String pathToNode) {
        StringBuilder requestURL = new StringBuilder((CharSequence)request.getScheme().name());
        requestURL.append("://");
        requestURL.append(request.getHeader((CharSequence)HttpHeaderNames.HOST));
        requestURL.append(request.getHttpRequest().uri());
        if (requestURL.charAt(requestURL.length() - 1) != '/') {
            requestURL.append('/');
        }
        requestURL.append(pathToNode);
        return HttpUtil.canonicalize((CharSequence)requestURL);
    }

    protected Predicate<IOption> getConfigSelector() {
        return option -> !option.hidden() && option != ControllerConfig.Option.CONFIG_FILE && option != ControllerConfig.Option.CONFIG_FILE_URL;
    }

    private void processPartitionMaster(IServletRequest request, IServletResponse response) {
        String partition = request.getParameter((CharSequence)"partition");
        String node = request.getParameter((CharSequence)"node");
        this.appCtx.getClusterStateManager().updateClusterPartition(Integer.parseInt(partition), node, true);
        response.setStatus(HttpResponseStatus.OK);
    }

    private void processMetadataNode(IServletRequest request, IServletResponse response) throws HyracksDataException {
        String node = request.getParameter((CharSequence)"node");
        this.appCtx.getNcLifecycleCoordinator().notifyMetadataNodeChange(node);
        response.setStatus(HttpResponseStatus.OK);
    }
}

