/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.SchemaToTypeInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

class AvroObjectInspectorGenerator {
    private final List<String> columnNames;
    private final List<TypeInfo> columnTypes;
    private final ObjectInspector oi;

    public AvroObjectInspectorGenerator(Schema schema) throws SerDeException {
        this.verifySchemaIsARecord(schema);
        this.columnNames = this.generateColumnNames(schema);
        this.columnTypes = SchemaToTypeInfo.generateColumnTypes(schema);
        assert (this.columnNames.size() == this.columnTypes.size());
        this.oi = this.createObjectInspector();
    }

    private void verifySchemaIsARecord(Schema schema) throws SerDeException {
        if (!schema.getType().equals((Object)Schema.Type.RECORD)) {
            throw new AvroSerdeException("Schema for table must be of type RECORD. Received type: " + schema.getType());
        }
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<TypeInfo> getColumnTypes() {
        return this.columnTypes;
    }

    public ObjectInspector getObjectInspector() {
        return this.oi;
    }

    private ObjectInspector createObjectInspector() throws SerDeException {
        ArrayList<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(this.columnNames.size());
        for (int i = 0; i < this.columnNames.size(); ++i) {
            columnOIs.add(i, this.createObjectInspectorWorker(this.columnTypes.get(i)));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, columnOIs);
    }

    private ObjectInspector createObjectInspectorWorker(TypeInfo ti) throws SerDeException {
        ObjectInspector result;
        if (!this.supportedCategories(ti)) {
            throw new AvroSerdeException("Don't yet support this type: " + ti);
        }
        switch (ti.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo pti = (PrimitiveTypeInfo)ti;
                result = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(pti);
                break;
            }
            case STRUCT: {
                StructTypeInfo sti = (StructTypeInfo)ti;
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>(sti.getAllStructFieldTypeInfos().size());
                for (TypeInfo typeInfo : sti.getAllStructFieldTypeInfos()) {
                    ois.add(this.createObjectInspectorWorker(typeInfo));
                }
                result = ObjectInspectorFactory.getStandardStructObjectInspector(sti.getAllStructFieldNames(), ois);
                break;
            }
            case MAP: {
                MapTypeInfo mti = (MapTypeInfo)ti;
                result = ObjectInspectorFactory.getStandardMapObjectInspector(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspector.PrimitiveCategory.STRING), this.createObjectInspectorWorker(mti.getMapValueTypeInfo()));
                break;
            }
            case LIST: {
                ListTypeInfo ati = (ListTypeInfo)ti;
                result = ObjectInspectorFactory.getStandardListObjectInspector(this.createObjectInspectorWorker(ati.getListElementTypeInfo()));
                break;
            }
            case UNION: {
                UnionTypeInfo uti = (UnionTypeInfo)ti;
                List<TypeInfo> allUnionObjectTypeInfos = uti.getAllUnionObjectTypeInfos();
                ArrayList<ObjectInspector> unionObjectInspectors = new ArrayList<ObjectInspector>(allUnionObjectTypeInfos.size());
                for (TypeInfo typeInfo : allUnionObjectTypeInfos) {
                    unionObjectInspectors.add(this.createObjectInspectorWorker(typeInfo));
                }
                result = ObjectInspectorFactory.getStandardUnionObjectInspector(unionObjectInspectors);
                break;
            }
            default: {
                throw new AvroSerdeException("No Hive categories matched: " + ti);
            }
        }
        return result;
    }

    private boolean supportedCategories(TypeInfo ti) {
        ObjectInspector.Category c = ti.getCategory();
        return c.equals((Object)ObjectInspector.Category.PRIMITIVE) || c.equals((Object)ObjectInspector.Category.MAP) || c.equals((Object)ObjectInspector.Category.LIST) || c.equals((Object)ObjectInspector.Category.STRUCT) || c.equals((Object)ObjectInspector.Category.UNION);
    }

    private List<String> generateColumnNames(Schema schema) {
        List fields = schema.getFields();
        ArrayList<String> fieldsList = new ArrayList<String>(fields.size());
        for (Schema.Field field : fields) {
            fieldsList.add(field.name());
        }
        return fieldsList;
    }
}

