/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.models.CopyStatusType;
import java.time.OffsetDateTime;
import java.util.Objects;

public class BlobCopyInfo {
    private final String copyId;
    private final String copySource;
    private final CopyStatusType copyStatus;
    private final String eTag;
    private final OffsetDateTime lastModified;
    private final String error;

    public BlobCopyInfo(String copySource, String copyId, CopyStatusType copyStatus, String eTag, OffsetDateTime lastModified, String error) {
        this.copyId = Objects.requireNonNull(copyId, "'copyId' cannot be null.");
        this.copySource = Objects.requireNonNull(copySource, "'copySource' cannot be null.");
        this.copyStatus = Objects.requireNonNull(copyStatus, "'copyStatus' cannot be null.");
        this.eTag = Objects.requireNonNull(eTag, "'eTag' cannot be null.");
        this.lastModified = lastModified;
        this.error = error;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public String getCopySourceUrl() {
        return this.copySource;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public String getError() {
        return this.error;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public String getETag() {
        return this.eTag;
    }
}

