/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.servicemetadata.S3ServiceMetadata;
import software.amazon.awssdk.utils.Logger;

@SdkPublicApi
public final class EnhancedS3ServiceMetadata
implements ServiceMetadata {
    private static final Logger log = Logger.loggerFor(EnhancedS3ServiceMetadata.class);
    private static final String REGIONAL_SETTING = "regional";
    private static final S3ServiceMetadata S3_SERVICE_METADATA = new S3ServiceMetadata();
    private volatile boolean profileSettingChecked = false;
    private volatile String profileSetting = null;

    @Override
    public URI endpointFor(Region region) {
        if (Region.US_EAST_1.equals(region) && !this.useUsEast1RegionalEndpoint()) {
            return URI.create("s3.amazonaws.com");
        }
        return S3_SERVICE_METADATA.endpointFor(region);
    }

    @Override
    public Region signingRegion(Region region) {
        return S3_SERVICE_METADATA.signingRegion(region);
    }

    @Override
    public List<Region> regions() {
        return S3_SERVICE_METADATA.regions();
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return S3_SERVICE_METADATA.servicePartitions();
    }

    private boolean useUsEast1RegionalEndpoint() {
        String env = EnhancedS3ServiceMetadata.envVarSetting();
        if (env != null) {
            return REGIONAL_SETTING.equalsIgnoreCase(env);
        }
        String profile = this.profileFileSetting();
        if (profile != null) {
            return REGIONAL_SETTING.equalsIgnoreCase(profile);
        }
        return false;
    }

    private static String envVarSetting() {
        return SdkSystemSetting.AWS_S3_US_EAST_1_REGIONAL_ENDPOINT.getStringValue().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String profileFileSetting() {
        if (!this.profileSettingChecked) {
            EnhancedS3ServiceMetadata enhancedS3ServiceMetadata = this;
            synchronized (enhancedS3ServiceMetadata) {
                if (!this.profileSettingChecked) {
                    try {
                        String profileName = ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
                        ProfileFile profileFile = ProfileFile.defaultProfileFile();
                        this.profileSetting = profileFile.profile(profileName).flatMap(p -> p.property("s3_us_east_1_regional_endpoint")).orElse(null);
                    }
                    catch (Throwable t) {
                        log.warn(() -> "Unable to load config file", t);
                    }
                }
                this.profileSettingChecked = true;
            }
        }
        return this.profileSetting;
    }
}

