/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientRunOn;
import reactor.netty.tcp.TcpResources;

final class TcpClientConnect
extends TcpClient {
    static final TcpClientConnect INSTANCE = new TcpClientConnect(ConnectionProvider.newConnection());
    final ConnectionProvider provider;

    TcpClientConnect(ConnectionProvider provider) {
        this.provider = Objects.requireNonNull(provider, "connectionProvider");
    }

    @Override
    public Mono<? extends Connection> connect(Bootstrap b) {
        if (b.config().group() == null) {
            TcpClientRunOn.configure(b, LoopResources.DEFAULT_NATIVE, TcpResources.get());
        }
        return this.provider.acquire(b);
    }
}

