/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class JSONDeserializerForTypes {
    private static final Map<String, IAType> primitiveTypeMap = new HashMap<String, IAType>();

    private JSONDeserializerForTypes() {
    }

    public static IAType convertFromJSON(JsonNode typeInJSON) throws Exception {
        String typeName = typeInJSON.get("type").asText();
        if (typeName.equals(AOrderedListType.class.getName())) {
            IAType itemType = JSONDeserializerForTypes.convertFromJSON(typeInJSON.get("item-type"));
            return new AOrderedListType(itemType, "ordered-list");
        }
        if (typeName.equals(AUnorderedListType.class.getName())) {
            IAType itemType = JSONDeserializerForTypes.convertFromJSON(typeInJSON.get("item-type"));
            return new AUnorderedListType(itemType, "unordered-list");
        }
        if (typeName.equals(AUnionType.class.getName())) {
            ArrayList<IAType> unionTypes = new ArrayList<IAType>();
            JsonNode fields = typeInJSON.get("fields");
            for (int i = 0; i < fields.size(); ++i) {
                JsonNode fieldType = fields.get(i);
                unionTypes.add(JSONDeserializerForTypes.convertFromJSON(fieldType));
            }
            return new AUnionType(unionTypes, "union");
        }
        if (typeName.equals(ARecordType.class.getName())) {
            String name = typeInJSON.get("name").asText();
            boolean openType = typeInJSON.get("open").asBoolean();
            JsonNode fields = typeInJSON.get("fields");
            String[] fieldNames = new String[fields.size()];
            IAType[] fieldTypes = new IAType[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                String fieldName;
                JsonNode field = fields.get(i);
                ArrayList names = Lists.newArrayList((Iterator)field.fieldNames());
                fieldNames[i] = fieldName = (String)names.get(0);
                fieldTypes[i] = JSONDeserializerForTypes.convertFromJSON(field.get(fieldName));
            }
            return new ARecordType(name, fieldNames, fieldTypes, openType);
        }
        return primitiveTypeMap.get(typeName.toUpperCase());
    }

    static {
        Class<BuiltinType> buildInTypeClass = BuiltinType.class;
        Stream.of(buildInTypeClass.getDeclaredFields()).filter(f -> f.getType().isAssignableFrom(BuiltinType.class)).forEach(f -> {
            try {
                primitiveTypeMap.put(f.getName().toUpperCase(), (IAType)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        });
        primitiveTypeMap.put("ASTERIX_TYPE", BuiltinType.ALL_TYPE);
    }
}

