/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.profiling;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.IPartitionWriterFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.common.job.profiling.counters.MultiResolutionEventProfiler;
import org.apache.hyracks.control.common.job.profiling.om.PartitionProfile;
import org.apache.hyracks.control.nc.Task;
import org.apache.hyracks.control.nc.profiling.ConnectorSenderProfilingFrameWriter;

public class ProfilingPartitionWriterFactory
implements IPartitionWriterFactory {
    private static final int N_SAMPLES = 64;
    private final IHyracksTaskContext ctx;
    private final IConnectorDescriptor cd;
    private final int senderIndex;
    private final IPartitionWriterFactory delegate;

    public ProfilingPartitionWriterFactory(IHyracksTaskContext ctx, IConnectorDescriptor cd, int senderIndex, IPartitionWriterFactory delegate) {
        this.ctx = ctx;
        this.cd = cd;
        this.senderIndex = senderIndex;
        this.delegate = delegate;
    }

    public IFrameWriter createFrameWriter(final int receiverIndex) throws HyracksDataException {
        final ConnectorSenderProfilingFrameWriter writer = new ConnectorSenderProfilingFrameWriter(this.ctx, this.delegate.createFrameWriter(receiverIndex), this.cd.getConnectorId(), this.senderIndex, receiverIndex);
        return new IFrameWriter(){
            private long openTime;
            private long closeTime;
            MultiResolutionEventProfiler mrep = new MultiResolutionEventProfiler(64);

            public void open() throws HyracksDataException {
                this.openTime = System.currentTimeMillis();
                writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.mrep.reportEvent();
                writer.nextFrame(buffer);
            }

            public void fail() throws HyracksDataException {
                writer.fail();
            }

            public void close() throws HyracksDataException {
                this.closeTime = System.currentTimeMillis();
                try {
                    ((Task)ProfilingPartitionWriterFactory.this.ctx).setPartitionSendProfile(new PartitionProfile(new PartitionId(ProfilingPartitionWriterFactory.this.ctx.getJobletContext().getJobId(), ProfilingPartitionWriterFactory.this.cd.getConnectorId(), ProfilingPartitionWriterFactory.this.senderIndex, receiverIndex), this.openTime, this.closeTime, this.mrep));
                }
                finally {
                    writer.close();
                }
            }

            public void flush() throws HyracksDataException {
                writer.flush();
            }
        };
    }
}

