/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.impl.AggregateResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class NumericSumAggTypeComputer
extends AggregateResultTypeComputer {
    public static final NumericSumAggTypeComputer INSTANCE = new NumericSumAggTypeComputer();

    private NumericSumAggTypeComputer() {
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        ATypeTag tag = strippedInputTypes[0].getTypeTag();
        switch (tag) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return AUnionType.createNullableType(BuiltinType.AINT64);
            }
            case FLOAT: 
            case DOUBLE: {
                return AUnionType.createNullableType(BuiltinType.ADOUBLE);
            }
            case ANY: {
                return BuiltinType.ANY;
            }
        }
        return BuiltinType.ANULL;
    }
}

