/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.opcallbacks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.context.BaseOperationTracker;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.common.IResource;

public class SecondaryIndexOperationTrackerFactory
implements ILSMOperationTrackerFactory {
    private static final long serialVersionUID = 1L;
    private final int datasetId;

    public SecondaryIndexOperationTrackerFactory(int datasetId) {
        this.datasetId = datasetId;
    }

    public ILSMOperationTracker getOperationTracker(INCServiceContext ctx, IResource resource) {
        IDatasetLifecycleManager dslcManager = ((INcApplicationContext)ctx.getApplicationContext()).getDatasetLifecycleManager();
        return new BaseOperationTracker(this.datasetId, dslcManager.getDatasetInfo(this.datasetId));
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.put("datasetId", this.datasetId);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return new SecondaryIndexOperationTrackerFactory(json.get("datasetId").asInt());
    }
}

