/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class LongRunningOperationStatus
extends ExpandableStringEnum<LongRunningOperationStatus> {
    private boolean completed;
    public static final LongRunningOperationStatus NOT_STARTED = LongRunningOperationStatus.fromString("NOT_STARTED", false);
    public static final LongRunningOperationStatus IN_PROGRESS = LongRunningOperationStatus.fromString("IN_PROGRESS", false);
    public static final LongRunningOperationStatus SUCCESSFULLY_COMPLETED = LongRunningOperationStatus.fromString("SUCCESSFULLY_COMPLETED", true);
    public static final LongRunningOperationStatus FAILED = LongRunningOperationStatus.fromString("FAILED", true);
    public static final LongRunningOperationStatus USER_CANCELLED = LongRunningOperationStatus.fromString("USER_CANCELLED", true);
    private static Map<String, LongRunningOperationStatus> operationStatusMap;

    public static LongRunningOperationStatus fromString(String name, boolean isComplete) {
        LongRunningOperationStatus status = LongRunningOperationStatus.fromString(name, LongRunningOperationStatus.class);
        if (status != null) {
            LongRunningOperationStatus operationStatus;
            if (operationStatusMap != null && operationStatusMap.containsKey(name) && (operationStatus = operationStatusMap.get(name)).isComplete() != isComplete) {
                throw new IllegalArgumentException(String.format("Cannot set complete status %s for operationstatus %s", isComplete, name));
            }
            status.completed = isComplete;
        }
        return status;
    }

    public boolean isComplete() {
        return this.completed;
    }

    static {
        HashMap<String, LongRunningOperationStatus> opStatusMap = new HashMap<String, LongRunningOperationStatus>();
        opStatusMap.put(NOT_STARTED.toString(), NOT_STARTED);
        opStatusMap.put(IN_PROGRESS.toString(), IN_PROGRESS);
        opStatusMap.put(SUCCESSFULLY_COMPLETED.toString(), SUCCESSFULLY_COMPLETED);
        opStatusMap.put(FAILED.toString(), FAILED);
        opStatusMap.put(USER_CANCELLED.toString(), USER_CANCELLED);
        operationStatusMap = Collections.unmodifiableMap(opStatusMap);
    }
}

