/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public abstract class AbstractFloatConstructorEvaluator
extends AbstractConstructorEvaluator {
    private final AMutableFloat aFloat = new AMutableFloat(0.0f);
    private final ISerializerDeserializer<AFloat> floatSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();

    protected AbstractFloatConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case FLOAT: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                this.resultStorage.reset();
                try {
                    ATypeHierarchy.getTypePromoteComputer((ATypeTag)inputType, (ATypeTag)ATypeTag.FLOAT).convertType(bytes, startOffset + 1, len - 1, this.out);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case DOUBLE: {
                this.resultStorage.reset();
                try {
                    ATypeHierarchy.getTypeDemoteComputer((ATypeTag)inputType, (ATypeTag)ATypeTag.FLOAT, (boolean)false).convertType(bytes, startOffset + 1, len - 1, this.out);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case BOOLEAN: {
                boolean b = ABooleanSerializerDeserializer.getBoolean((byte[])bytes, (int)(startOffset + 1));
                this.aFloat.setValue(b ? 1.0f : 0.0f);
                this.resultStorage.reset();
                this.floatSerde.serialize((Object)this.aFloat, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                if (NumberUtils.parseFloat(this.utf8Ptr, this.aFloat)) {
                    this.resultStorage.reset();
                    this.floatSerde.serialize((Object)this.aFloat, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    @Override
    protected final BuiltinType getTargetType() {
        return BuiltinType.AFLOAT;
    }
}

