/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.models.FileSystem;
import com.azure.storage.file.datalake.implementation.models.ServicesListFileSystemsHeaders;
import com.azure.storage.file.datalake.implementation.models.ServicesListFileSystemsResponse;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private final ServicesService service;
    private final AzureDataLakeStorageRestAPIImpl client;

    ServicesImpl(AzureDataLakeStorageRestAPIImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<FileSystem>> listFileSystemsSinglePageAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        String resource = "account";
        String accept = "application/json";
        return this.service.listFileSystems(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getFilesystems(), null, (Object)((ServicesListFileSystemsHeaders)res.getDeserializedHeaders())));
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureDataLakeStorage")
    public static interface ServicesService {
        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ServicesListFileSystemsResponse> listFileSystems(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="continuation") String var4, @QueryParam(value="maxResults") Integer var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

