/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import java.nio.file.Paths;
import java.util.Objects;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.hyracks.storage.common.LocalResource;

public class DatasetResourceReference
extends ResourceReference {
    private final int datasetId;
    private final int partitionId;
    private final long resourceId;

    private DatasetResourceReference(LocalResource localResource) {
        super(Paths.get(localResource.getPath(), ".metadata").toString());
        DatasetLocalResource dsResource = (DatasetLocalResource)localResource.getResource();
        this.datasetId = dsResource.getDatasetId();
        this.partitionId = dsResource.getPartition();
        this.resourceId = localResource.getId();
    }

    public static DatasetResourceReference of(LocalResource localResource) {
        Objects.requireNonNull(localResource);
        return DatasetResourceReference.parse(localResource);
    }

    public int getDatasetId() {
        return this.datasetId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getResourceId() {
        return this.resourceId;
    }

    private static DatasetResourceReference parse(LocalResource localResource) {
        return new DatasetResourceReference(localResource);
    }
}

