/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server.utils;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.BaseRequest;
import org.apache.hyracks.http.server.FormUrlEncodedRequest;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.util.ThrowingConsumer;
import org.apache.hyracks.util.ThrowingFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern PARENT_DIR = Pattern.compile("/[^./]+/\\.\\./");
    private static final Charset DEFAULT_RESPONSE_CHARSET = StandardCharsets.UTF_8;
    public static final AsciiString X_FORWARDED_PROTO = AsciiString.cached((String)"x-forwarded-proto");
    public static final AsciiString PERMANENT = AsciiString.cached((String)"permanent");

    private HttpUtil() {
    }

    public static IServletRequest toServletRequest(ChannelHandlerContext ctx, FullHttpRequest request, HttpScheme scheme, boolean ignoreQueryParameters) {
        return "application/x-www-form-urlencoded".equals(HttpUtil.getContentTypeOnly((HttpRequest)request)) && !HttpMethod.GET.equals((Object)request.method()) ? FormUrlEncodedRequest.create(ctx, request, scheme, ignoreQueryParameters) : BaseRequest.create(ctx, request, scheme, ignoreQueryParameters);
    }

    public static boolean ignoreQueryParameters(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method) || HttpMethod.DELETE.equals((Object)method) || HttpMethod.PUT.equals((Object)method);
    }

    public static String getContentTypeOnly(IServletRequest request) {
        return HttpUtil.getContentTypeOnly((HttpRequest)request.getHttpRequest());
    }

    public static String getContentTypeOnly(HttpRequest request) {
        String contentType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return contentType == null ? null : contentType.split(";")[0];
    }

    public static Charset getRequestCharset(HttpRequest request) {
        return io.netty.handler.codec.http.HttpUtil.getCharset((HttpMessage)request, (Charset)StandardCharsets.UTF_8);
    }

    public static String getRequestBody(IServletRequest request) {
        FullHttpRequest httpRequest = request.getHttpRequest();
        return httpRequest.content().toString(HttpUtil.getRequestCharset((HttpRequest)httpRequest));
    }

    public static Charset setContentType(IServletResponse response, String type, IServletRequest fromRequest) throws IOException {
        Charset preferredCharset = HttpUtil.getPreferredCharset(fromRequest);
        HttpUtil.setContentType(response, type, preferredCharset);
        return preferredCharset;
    }

    public static void setContentType(IServletResponse response, String type, Charset charset) throws IOException {
        response.setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, type + "; charset=" + charset.name());
    }

    public static void setContentType(IServletResponse response, String type) throws IOException {
        response.setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, type);
    }

    public static void setServerHeader(IServletResponse response, String value) throws IOException {
        response.setHeader((CharSequence)HttpHeaderNames.SERVER, value);
    }

    public static Map<String, String> getRequestHeaders(IServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        request.getHttpRequest().headers().forEach(entry -> headers.put((String)entry.getKey(), (String)entry.getValue()));
        return headers;
    }

    public static String mime(String extension) {
        switch (extension) {
            case ".png": {
                return "image/png";
            }
            case ".eot": {
                return "application/vnd.ms-fontobject";
            }
            case ".svg": {
                return "image/svg+xml\t";
            }
            case ".ttf": {
                return "application/x-font-ttf";
            }
            case ".woff": 
            case ".woff2": {
                return "application/x-font-woff";
            }
            case ".html": {
                return "text/html";
            }
            case ".css": {
                return "text/css";
            }
            case ".txt": {
                return "text/plain";
            }
            case ".ico": {
                return "image/x-icon";
            }
            case ".js": {
                return "application/javascript";
            }
        }
        return null;
    }

    public static String canonicalize(CharSequence requestURL) {
        String clusterURL = "";
        String newClusterURL = requestURL.toString();
        while (!clusterURL.equals(newClusterURL)) {
            clusterURL = newClusterURL;
            newClusterURL = PARENT_DIR.matcher(clusterURL).replaceAll("/");
        }
        return clusterURL;
    }

    public static void setConnectionHeader(HttpRequest request, DefaultHttpResponse response) {
        boolean keepAlive = io.netty.handler.codec.http.HttpUtil.isKeepAlive((HttpMessage)request);
        AsciiString connectionHeaderValue = keepAlive ? HttpHeaderValues.KEEP_ALIVE : HttpHeaderValues.CLOSE;
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)connectionHeaderValue);
    }

    public static Charset getPreferredCharset(IServletRequest request) {
        return HttpUtil.getPreferredCharset(request, DEFAULT_RESPONSE_CHARSET);
    }

    public static Charset getPreferredCharset(IServletRequest request, Charset defaultCharset) {
        String acceptCharset = request.getHeader((CharSequence)HttpHeaderNames.ACCEPT_CHARSET);
        if (acceptCharset == null) {
            return defaultCharset;
        }
        Optional<Charset> preferredCharset = Stream.of(StringUtils.split((String)acceptCharset, (String)",")).map(WeightedHeaderValue::new).sorted().map(WeightedHeaderValue::getValueDefaultStar).filter(value -> {
            if (!Charset.isSupported(value)) {
                LOGGER.info("disregarding unsupported charset '{}'", value);
                return false;
            }
            return true;
        }).map(Charset::forName).findFirst();
        return preferredCharset.orElse(defaultCharset);
    }

    public static String trimQuery(String uri) {
        int i = uri.indexOf(63);
        return i < 0 ? uri : uri.substring(0, i);
    }

    public static void consumeStreamInterruptibly(CloseableHttpResponse response, ThrowingConsumer<Reader> streamProcessor, ExecutorService executor, Supplier<String> descriptionSupplier) throws InterruptedException, ExecutionException, IOException {
        HttpUtil.processStreamInterruptibly(response, ThrowingConsumer.asFunction(streamProcessor), executor, descriptionSupplier);
    }

    public static <T> T processStreamInterruptibly(CloseableHttpResponse response, ThrowingFunction<Reader, T> streamProcessor, ExecutorService executor, Supplier<String> descriptionSupplier) throws IOException, InterruptedException, ExecutionException {
        String description = descriptionSupplier.get();
        Future<Object> readFuture = executor.submit(() -> {
            Thread.currentThread().setName(description);
            final InputStreamReader reader = new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8);
            return streamProcessor.process((Object)new Reader(){

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    return reader.read(cbuf, off, len);
                }

                @Override
                public void close() throws IOException {
                    LOGGER.debug("ignoring close on {}", (Object)reader);
                }
            });
        });
        try {
            return (T)readFuture.get();
        }
        catch (InterruptedException ex) {
            executor.submit(() -> {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.debug("{} ignoring exception thrown on stream close due to interrupt", (Object)description, (Object)e);
                }
            });
            try {
                readFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException te) {
                LOGGER.warn("{} did not exit on stream close due to interrupt after 1s", (Object)description);
                readFuture.cancel(true);
            }
            catch (ExecutionException ee) {
                LOGGER.debug("ignoring exception awaiting aborted {} shutdown", (Object)description, (Object)ee);
            }
            throw ex;
        }
    }

    public static HttpScheme getScheme(HttpServer server, FullHttpRequest request) {
        return server.getScheme() == HttpScheme.HTTPS || "https".equals(request.headers().get((CharSequence)X_FORWARDED_PROTO)) ? HttpScheme.HTTPS : HttpScheme.HTTP;
    }

    public static Optional<String> extractQueryParameter(String uri, String parameterName) {
        return HttpUtil.extractQueryParameters(uri, parameterName).map(values -> values[0]);
    }

    public static Optional<String[]> extractQueryParameters(String uri, String parameterName) {
        String[] values = (String[])URLEncodedUtils.parse((String)uri, (Charset)StandardCharsets.UTF_8, (char[])new char[]{'?', '&'}).stream().filter(pair -> pair.getName().equals(parameterName)).map(NameValuePair::getValue).toArray(String[]::new);
        return values.length == 0 ? Optional.empty() : Optional.of(values);
    }

    private static class WeightedHeaderValue
    implements Comparable<WeightedHeaderValue> {
        final String value;
        final double weight;

        WeightedHeaderValue(String value) {
            String[] splits = StringUtils.split((String)value, (String)";");
            this.value = splits[0].trim();
            if (splits.length == 1) {
                this.weight = 1.0;
            } else {
                OptionalDouble specifiedWeight = Stream.of(splits).skip(1L).map(String::trim).map(String::toLowerCase).filter(a -> a.startsWith("q=")).mapToDouble(segment -> Double.parseDouble(StringUtils.splitByWholeSeparator((String)segment, (String)"q=")[0])).findFirst();
                this.weight = specifiedWeight.orElse(1.0);
            }
        }

        public String getValue() {
            return this.value;
        }

        public String getValueDefaultStar() {
            return "*".equals(this.value) ? DEFAULT_RESPONSE_CHARSET.name() : this.value;
        }

        public double getWeight() {
            return this.weight;
        }

        @Override
        public int compareTo(WeightedHeaderValue o) {
            return Double.compare(o.weight, this.weight);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightedHeaderValue that = (WeightedHeaderValue)o;
            return Double.compare(that.weight, this.weight) == 0 && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.weight);
        }
    }

    public static class ContentType {
        public static final String ADM = "adm";
        public static final String JSON = "json";
        public static final String CSV = "csv";
        public static final String APPLICATION_ADM = "application/x-adm";
        public static final String APPLICATION_JSON = "application/json";
        public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
        public static final String TEXT_CSV = "text/csv";
        public static final String IMG_PNG = "image/png";
        public static final String TEXT_HTML = "text/html";
        public static final String TEXT_PLAIN = "text/plain";
        public static final String APPLICATION_ZIP = "application/zip";
        public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

        private ContentType() {
        }
    }
}

