/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.ViewUtil;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.rewrites.SqlppQueryRewriter;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.SourceLocation;

class SqlppFunctionBodyRewriter
extends SqlppQueryRewriter {
    public SqlppFunctionBodyRewriter(IParserFactory parserFactory) {
        super(parserFactory);
    }

    @Override
    public void rewrite(LangRewritingContext context, IReturningStatement topStatement, boolean allowNonStoredUdfCalls, boolean inlineUdfsAndViews, Collection<VarIdentifier> externalVars) throws CompilationException {
        if (inlineUdfsAndViews) {
            throw new CompilationException(ErrorCode.ILLEGAL_STATE, topStatement.getSourceLocation(), new Serializable[]{""});
        }
        this.setup(context, topStatement, externalVars, allowNonStoredUdfCalls, inlineUdfsAndViews);
        this.resolveFunctionCalls();
        this.generateColumnNames();
        this.substituteGroupbyKeyExpression();
        this.rewriteGroupBys();
        this.rewriteSetOperations();
        this.inlineColumnAlias();
        this.rewriteWindowExpressions();
        this.rewriteGroupingSets();
        this.rewriteWindowExpressions();
        this.variableCheckAndRewrite();
        this.extractAggregatesFromCaseExpressions();
        this.rewriteGroupByAggregationSugar();
        this.rewriteWindowAggregationSugar();
        this.rewriteOperatorExpression();
        this.rewriteCaseExpressions();
        this.rewriteListInputFunctions();
        this.rewriteRightJoins();
    }

    static Expression castViewBodyAsType(LangRewritingContext context, Expression bodyExpr, IAType itemType, Triple<String, String, String> temporalDataFormat, DatasetFullyQualifiedName viewName, SourceLocation sourceLoc) throws CompilationException {
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new CompilationException(ErrorCode.COMPILATION_TYPE_UNSUPPORTED, sourceLoc, new Serializable[]{viewName, itemType.getTypeName()});
        }
        ARecordType recordType = (ARecordType)itemType;
        if (recordType.isOpen()) {
            throw new CompilationException(ErrorCode.COMPILATION_TYPE_UNSUPPORTED, sourceLoc, new Serializable[]{viewName, itemType.getTypeName()});
        }
        String[] fieldNames = recordType.getFieldNames();
        IAType[] fieldTypes = recordType.getFieldTypes();
        int n = fieldNames.length;
        if (n == 0) {
            throw new CompilationException(ErrorCode.COMPILATION_TYPE_UNSUPPORTED, sourceLoc, new Serializable[]{viewName, itemType.getTypeName()});
        }
        ArrayList<FieldBinding> projections = new ArrayList<FieldBinding>(n);
        ArrayList<AbstractClause> letWhereClauseList = new ArrayList<AbstractClause>(n + 1);
        ArrayList<Expression> filters = null;
        VarIdentifier fromVar = context.newVariable();
        for (int i = 0; i < n; ++i) {
            IAType primeType;
            boolean fieldTypeNullable;
            String fieldName = fieldNames[i];
            IAType fieldType = fieldTypes[i];
            if (fieldType.getTypeTag() == ATypeTag.UNION) {
                AUnionType unionType = (AUnionType)fieldType;
                fieldTypeNullable = unionType.isNullableType();
                if (!fieldTypeNullable) {
                    throw new CompilationException(ErrorCode.COMPILATION_TYPE_UNSUPPORTED, sourceLoc, new Serializable[]{viewName, unionType.toString()});
                }
                primeType = unionType.getActualType();
            } else {
                fieldTypeNullable = false;
                primeType = fieldType;
            }
            Expression expr = ViewUtil.createFieldAccessExpression((VarIdentifier)fromVar, (String)fieldName, (SourceLocation)sourceLoc);
            Expression projectExpr = ViewUtil.createTypeConvertExpression((Expression)expr, (IAType)primeType, temporalDataFormat, (DatasetFullyQualifiedName)viewName, (SourceLocation)sourceLoc);
            VarIdentifier projectVar = context.newVariable();
            VariableExpr projectVarRef1 = new VariableExpr(projectVar);
            projectVarRef1.setSourceLocation(sourceLoc);
            LetClause letClause = new LetClause(projectVarRef1, projectExpr);
            letWhereClauseList.add((AbstractClause)letClause);
            VariableExpr projectVarRef2 = new VariableExpr(projectVar);
            projectVarRef2.setSourceLocation(sourceLoc);
            projections.add(new FieldBinding((Expression)new LiteralExpr((Literal)new StringLiteral(fieldName)), (Expression)projectVarRef2));
            if (fieldTypeNullable) continue;
            VariableExpr projectVarRef3 = new VariableExpr(projectVar);
            projectVarRef3.setSourceLocation(sourceLoc);
            Expression notIsNullExpr = ViewUtil.createNotIsNullExpression((Expression)projectVarRef3, (SourceLocation)sourceLoc);
            if (filters == null) {
                filters = new ArrayList<Expression>();
            }
            filters.add(notIsNullExpr);
        }
        VariableExpr fromVarRef = new VariableExpr(fromVar);
        fromVarRef.setSourceLocation(sourceLoc);
        FromClause fromClause = new FromClause(Collections.singletonList(new FromTerm(bodyExpr, fromVarRef, null, null)));
        fromClause.setSourceLocation(sourceLoc);
        if (filters != null && !filters.isEmpty()) {
            Expression whereExpr;
            if (filters.size() == 1) {
                whereExpr = (Expression)filters.get(0);
            } else {
                CallExpr andExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.AND), (List)filters);
                andExpr.setSourceLocation(sourceLoc);
                whereExpr = andExpr;
            }
            WhereClause whereClause = new WhereClause(whereExpr);
            whereClause.setSourceLocation(sourceLoc);
            letWhereClauseList.add((AbstractClause)whereClause);
        }
        RecordConstructor recordConstr = new RecordConstructor(projections);
        recordConstr.setSourceLocation(sourceLoc);
        SelectClause selectClause = new SelectClause(new SelectElement((Expression)recordConstr), null, false);
        selectClause.setSourceLocation(sourceLoc);
        SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, letWhereClauseList, null, null);
        selectBlock.setSourceLocation(sourceLoc);
        SelectSetOperation selectSetOperation = new SelectSetOperation(new SetOperationInput(selectBlock, null), null);
        selectSetOperation.setSourceLocation(sourceLoc);
        SelectExpression selectExpression = new SelectExpression(null, selectSetOperation, null, null, true);
        selectExpression.setSourceLocation(sourceLoc);
        return selectExpression;
    }
}

