/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.expression.AbstractCallExpression;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.util.CommonFunctionMapUtil;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class FunctionUtil {
    public static final String IMPORT_PRIVATE_FUNCTIONS = "import-private-functions";
    private static final DataverseName FN_DATASET_DATAVERSE_NAME = FunctionSignature.getDataverseName((FunctionIdentifier)BuiltinFunctions.DATASET);
    private static final String FN_DATASET_NAME = BuiltinFunctions.DATASET.getName();

    public static BuiltinFunctionInfo getFunctionInfo(FunctionIdentifier fi) {
        return BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)fi);
    }

    public static TypeSignature getTypeDependencyFromFunctionParameter(TypeExpression typeExpr, DataverseName defaultDataverse) {
        switch (typeExpr.getTypeKind()) {
            case ORDEREDLIST: {
                return FunctionUtil.getTypeDependencyFromFunctionParameter(((OrderedListTypeDefinition)typeExpr).getItemTypeExpression(), defaultDataverse);
            }
            case UNORDEREDLIST: {
                return FunctionUtil.getTypeDependencyFromFunctionParameter(((UnorderedListTypeDefinition)typeExpr).getItemTypeExpression(), defaultDataverse);
            }
            case TYPEREFERENCE: {
                TypeReferenceExpression typeRef = (TypeReferenceExpression)typeExpr;
                String typeName = ((Identifier)typeRef.getIdent().getSecond()).toString();
                BuiltinType builtinType = BuiltinTypeMap.getBuiltinType((String)typeName);
                if (builtinType != null) {
                    return null;
                }
                DataverseName typeDataverseName = typeRef.getIdent().getFirst() != null ? (DataverseName)typeRef.getIdent().getFirst() : defaultDataverse;
                return new TypeSignature(typeDataverseName, typeName);
            }
            case RECORD: {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalStateException();
    }

    public static FunctionSignature resolveFunctionCall(FunctionSignature fs, SourceLocation sourceLoc, MetadataProvider metadataProvider, BiFunction<String, Integer, FunctionSignature> builtinFunctionResolver, boolean searchUdfs, Map<FunctionSignature, FunctionDecl> declaredFunctionMap, boolean allowNonStoredUdfCalls) throws CompilationException {
        FunctionSignature fsBuiltin;
        String name;
        String mappedName;
        DataverseName dataverse = fs.getDataverseName();
        if (dataverse == null) {
            dataverse = metadataProvider.getDefaultDataverseName();
        }
        if (searchUdfs && !FunctionUtil.isBuiltinFunctionDataverse(dataverse)) {
            FunctionSignature fsWithDv = fs.getDataverseName() == null ? new FunctionSignature(dataverse, fs.getName(), fs.getArity()) : fs;
            FunctionSignature fsWithDvVarargs = new FunctionSignature(fsWithDv.getDataverseName(), fsWithDv.getName(), -1);
            FunctionDecl fd = declaredFunctionMap.get(fsWithDv);
            if (fd == null) {
                fd = declaredFunctionMap.get(fsWithDvVarargs);
            }
            if (fd != null) {
                if (!allowNonStoredUdfCalls && !fd.isStored()) {
                    throw new CompilationException(ErrorCode.ILLEGAL_FUNCTION_USE, sourceLoc, new Serializable[]{fd.getSignature().toString()});
                }
                return fd.getSignature();
            }
            try {
                org.apache.asterix.metadata.entities.Function fn = metadataProvider.lookupUserDefinedFunction(fsWithDv);
                if (fn == null) {
                    fn = metadataProvider.lookupUserDefinedFunction(fsWithDvVarargs);
                }
                if (fn != null) {
                    return fn.getSignature();
                }
            }
            catch (AlgebricksException e) {
                throw new CompilationException(ErrorCode.UNKNOWN_FUNCTION, (Throwable)e, sourceLoc, new Serializable[]{fs.toString()});
            }
            if (fs.getDataverseName() != null) {
                Dataverse dv;
                try {
                    dv = metadataProvider.findDataverse(dataverse);
                }
                catch (AlgebricksException e) {
                    throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, (Throwable)e, sourceLoc, new Serializable[]{dataverse});
                }
                if (dv == null) {
                    throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, sourceLoc, new Serializable[]{dataverse});
                }
            }
        }
        if ((mappedName = CommonFunctionMapUtil.getFunctionMapping(name = fs.getName().toLowerCase())) != null) {
            name = mappedName;
        }
        if ((fsBuiltin = builtinFunctionResolver.apply(name, fs.getArity())) == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_FUNCTION, sourceLoc, new Serializable[]{fs.toString()});
        }
        return fsBuiltin;
    }

    public static boolean isBuiltinFunctionSignature(FunctionSignature fs) {
        return FunctionUtil.isBuiltinFunctionDataverse(Objects.requireNonNull(fs.getDataverseName())) || BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)fs.createFunctionIdentifier()) != null;
    }

    private static boolean isBuiltinFunctionDataverse(DataverseName dataverse) {
        return FunctionConstants.ASTERIX_DV.equals((Object)dataverse) || FunctionConstants.ALGEBRICKS_DV.equals((Object)dataverse);
    }

    public static BiFunction<String, Integer, FunctionSignature> createBuiltinFunctionResolver(MetadataProvider metadataProvider) {
        boolean includePrivateFunctions = FunctionUtil.getImportPrivateFunctions(metadataProvider);
        return FunctionUtil.createBuiltinFunctionResolver(includePrivateFunctions);
    }

    public static BiFunction<String, Integer, FunctionSignature> createBuiltinFunctionResolver(boolean includePrivateFunctions) {
        return (name, arity) -> {
            String builtinName = name.replace('_', '-');
            BuiltinFunctionInfo finfo = BuiltinFunctions.resolveBuiltinFunction((String)builtinName, (int)arity);
            if (finfo == null) {
                return null;
            }
            if (!includePrivateFunctions && finfo.isPrivate()) {
                return null;
            }
            return new FunctionSignature(finfo.getFunctionIdentifier());
        };
    }

    public static List<List<Triple<DataverseName, String, String>>> getFunctionDependencies(FunctionDecl fd, IQueryRewriter rewriter) throws CompilationException {
        Expression normBody = fd.getNormalizedFuncBody();
        if (normBody == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, fd.getSourceLocation(), new Serializable[]{fd.getSignature().toString()});
        }
        ArrayList<Triple<DataverseName, String, String>> datasetDependencies = new ArrayList<Triple<DataverseName, String, String>>();
        ArrayList<Triple<DataverseName, String, String>> synonymDependencies = new ArrayList<Triple<DataverseName, String, String>>();
        ArrayList<Triple<DataverseName, String, String>> functionDependencies = new ArrayList<Triple<DataverseName, String, String>>();
        ExpressionUtils.collectDependencies(normBody, rewriter, datasetDependencies, synonymDependencies, functionDependencies);
        List typeDependencies = Collections.emptyList();
        return org.apache.asterix.metadata.entities.Function.createDependencies(datasetDependencies, functionDependencies, typeDependencies, synonymDependencies);
    }

    public static List<List<Triple<DataverseName, String, String>>> getExternalFunctionDependencies(Collection<TypeSignature> dependentTypes) {
        List datasetDependencies = Collections.emptyList();
        List functionDependencies = Collections.emptyList();
        ArrayList<Triple> typeDependencies = new ArrayList<Triple>(dependentTypes.size());
        List synonymDependencies = Collections.emptyList();
        for (TypeSignature t : dependentTypes) {
            typeDependencies.add(new Triple((Object)t.getDataverseName(), (Object)t.getName(), null));
        }
        return org.apache.asterix.metadata.entities.Function.createDependencies(datasetDependencies, functionDependencies, typeDependencies, synonymDependencies);
    }

    public static boolean isBuiltinDatasetFunction(FunctionSignature fs) {
        return Objects.equals(FN_DATASET_DATAVERSE_NAME, fs.getDataverseName()) && Objects.equals(FN_DATASET_NAME, fs.getName());
    }

    public static Triple<DatasetFullyQualifiedName, Boolean, DatasetFullyQualifiedName> parseDatasetFunctionArguments(AbstractCallExpression datasetFn) throws CompilationException {
        List<Expression> argList = datasetFn.getExprList();
        DatasetFullyQualifiedName datasetOrViewName = FunctionUtil.parseDatasetFunctionArguments(argList, 0, datasetFn.getSourceLocation(), ExpressionUtils::getStringLiteral);
        boolean isView = argList.size() > 2 && Boolean.TRUE.equals(ExpressionUtils.getBooleanLiteral(argList.get(2)));
        DatasetFullyQualifiedName synonymName = argList.size() > 3 ? FunctionUtil.parseDatasetFunctionArguments(argList, 3, datasetFn.getSourceLocation(), ExpressionUtils::getStringLiteral) : null;
        return new Triple((Object)datasetOrViewName, (Object)isView, (Object)synonymName);
    }

    public static DatasetFullyQualifiedName parseDatasetFunctionArguments(AbstractFunctionCallExpression datasetFn) throws CompilationException {
        return FunctionUtil.parseDatasetFunctionArguments(datasetFn.getArguments(), 0, datasetFn.getSourceLocation(), FunctionUtil::getStringConstant);
    }

    private static <T> DatasetFullyQualifiedName parseDatasetFunctionArguments(List<T> datasetFnArgs, int startPos, SourceLocation sourceLoc, Function<T, String> stringAccessor) throws CompilationException {
        DataverseName dataverseName;
        String dataverseNameArg = stringAccessor.apply(datasetFnArgs.get(startPos));
        if (dataverseNameArg == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Invalid argument to dataset()"});
        }
        try {
            dataverseName = DataverseName.createFromCanonicalForm((String)dataverseNameArg);
        }
        catch (AsterixException e) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{e, "Invalid argument to dataset()"});
        }
        String datasetName = stringAccessor.apply(datasetFnArgs.get(startPos + 1));
        if (datasetName == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Invalid argument to dataset()"});
        }
        return new DatasetFullyQualifiedName(dataverseName, datasetName);
    }

    private static String getStringConstant(Mutable<ILogicalExpression> arg) {
        return ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)arg.getValue()));
    }

    private static boolean getImportPrivateFunctions(MetadataProvider metadataProvider) {
        String value = (String)metadataProvider.getConfig().get(IMPORT_PRIVATE_FUNCTIONS);
        return value != null && Boolean.parseBoolean(value.toLowerCase());
    }

    public static FunctionDecl parseStoredFunction(org.apache.asterix.metadata.entities.Function function, IParserFactory parserFactory, IWarningCollector warningCollector, SourceLocation sourceLoc) throws CompilationException {
        if (!function.getLanguage().equals(parserFactory.getLanguage())) {
            throw new CompilationException(ErrorCode.COMPILATION_INCOMPATIBLE_FUNCTION_LANGUAGE, sourceLoc, new Serializable[]{function.getLanguage(), function.getSignature().toString(), parserFactory.getLanguage()});
        }
        IParser parser = parserFactory.createParser(new StringReader(function.getFunctionBody()));
        try {
            FunctionDecl functionDecl = parser.parseFunctionBody(function.getSignature(), function.getParameterNames(), true);
            functionDecl.setSourceLocation(sourceLoc);
            if (warningCollector != null) {
                parser.getWarnings(warningCollector);
            }
            return functionDecl;
        }
        catch (CompilationException e) {
            throw new CompilationException(ErrorCode.COMPILATION_BAD_FUNCTION_DEFINITION, (Throwable)e, sourceLoc, new Serializable[]{function.getSignature(), e.getMessage()});
        }
    }
}

