/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.net.InetSocketAddress;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.IReplicationDestination;
import org.apache.asterix.replication.api.ReplicationDestination;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicaFailedMessage
implements INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final InetSocketAddress replicaAddress;
    private final Exception failure;

    public ReplicaFailedMessage(InetSocketAddress replicaAddress, Exception failure) {
        this.replicaAddress = replicaAddress;
        this.failure = failure;
    }

    public void handle(INcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        LOGGER.info("replica at {} failed", (Object)this.replicaAddress);
        ReplicationDestination dest = ReplicationDestination.at(NetworkUtil.ensureUnresolved((InetSocketAddress)this.replicaAddress));
        appCtx.getReplicationManager().notifyFailure((IReplicationDestination)dest, this.failure);
    }

    public String toString() {
        return ReplicaFailedMessage.class.getSimpleName();
    }
}

