/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismOperatorVisitor;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ReuseWindowAggregateRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.WINDOW) {
            return false;
        }
        WindowOperator winOp1 = (WindowOperator)op1;
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)op1.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.WINDOW) {
            return false;
        }
        WindowOperator winOp2 = (WindowOperator)op2;
        if (!IsomorphismOperatorVisitor.compareWindowPartitionSpec((WindowOperator)winOp1, (WindowOperator)winOp2)) {
            return false;
        }
        ArrayList<LogicalVariable> assignVars = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> assignExprs = new ArrayList<MutableObject>();
        List varsOp1 = winOp1.getVariables();
        List varsOp2 = winOp2.getVariables();
        List exprsOp1 = winOp1.getExpressions();
        List exprsOp2 = winOp2.getExpressions();
        Iterator varsOp1Iter = varsOp1.iterator();
        Iterator exprsOp1Iter = exprsOp1.iterator();
        while (varsOp1Iter.hasNext()) {
            LogicalVariable varOp1 = (LogicalVariable)varsOp1Iter.next();
            Mutable exprOp1 = (Mutable)exprsOp1Iter.next();
            VariableReferenceExpression varOp2Ref = OperatorManipulationUtil.findAssignedVariable((List)varsOp2, (List)exprsOp2, (ILogicalExpression)((ILogicalExpression)exprOp1.getValue()));
            if (varOp2Ref == null) continue;
            varsOp1Iter.remove();
            exprsOp1Iter.remove();
            assignVars.add(varOp1);
            assignExprs.add(new MutableObject((Object)varOp2Ref));
        }
        if (assignVars.isEmpty()) {
            return false;
        }
        AssignOperator assignOp = new AssignOperator(assignVars, assignExprs);
        assignOp.getInputs().add(new MutableObject((Object)winOp1));
        assignOp.setSourceLocation(winOp1.getSourceLocation());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        opRef.setValue((Object)assignOp);
        return true;
    }
}

