/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested;

import java.io.IOException;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.IFieldValue;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.ArrayConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.PrimitiveConverterProvider;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.PrimitiveType;

class ObjectConverter
extends AbstractComplexConverter {
    private IARecordBuilder builder;

    public ObjectConverter(AbstractComplexConverter parent, int index, GroupType parquetType, ParquetConverterContext context) {
        super(parent, index, parquetType, context);
    }

    public ObjectConverter(AbstractComplexConverter parent, IValueReference fieldName, int index, GroupType parquetType, ParquetConverterContext context) {
        super(parent, fieldName, index, parquetType, context);
    }

    public void start() {
        this.tempStorage = this.context.enterObject();
        this.builder = this.context.getObjectBuilder(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
    }

    public void end() {
        try {
            this.builder.write(this.getParentDataOutput(), true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.addThisValueToParent();
        this.context.exitObject(this.tempStorage, null, this.builder);
        this.tempStorage = null;
        this.builder = null;
    }

    @Override
    public void addValue(IFieldValue value) {
        try {
            this.builder.addField(value.getFieldName(), (IValueReference)this.getValue());
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected PrimitiveConverter createAtomicConverter(GroupType type, int index) {
        try {
            PrimitiveType primitiveType = type.getType(index).asPrimitiveType();
            IMutableValueStorage fieldName = this.context.getSerializedFieldName(type.getFieldName(index));
            return PrimitiveConverterProvider.createPrimitiveConverter(primitiveType, this, (IValueReference)fieldName, index, this.context);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected ArrayConverter createArrayConverter(GroupType type, int index) {
        try {
            IMutableValueStorage childFieldName = this.context.getSerializedFieldName(type.getFieldName(index));
            GroupType arrayType = type.getType(index).asGroupType();
            return new ArrayConverter(this, (IValueReference)childFieldName, index, arrayType, this.context);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected ObjectConverter createObjectConverter(GroupType type, int index) {
        try {
            IMutableValueStorage childFieldName = this.context.getSerializedFieldName(type.getFieldName(index));
            GroupType objectType = type.getType(index).asGroupType();
            return new ObjectConverter(this, (IValueReference)childFieldName, index, objectType, this.context);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

