/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientUtils {
    private static final Log log = LogFactory.getLog(ClientUtils.class);

    public static TransportOutDescription inferOutTransport(AxisConfiguration ac, EndpointReference epr, MessageContext msgctx) throws AxisFault {
        String transportURI = (String)msgctx.getProperty("TransportURL");
        if (transportURI != null && !"".equals(transportURI)) {
            String transport = Utils.getURIScheme(transportURI);
            if (transport != null) {
                TransportOutDescription transportOut = ac.getTransportOut(transport);
                if (transportOut == null) {
                    log.error((Object)("No Tranport Sender found for : " + transport));
                    throw new AxisFault("No Tranport Sender found for : " + transport);
                }
                return ac.getTransportOut(transport);
            }
            log.error((Object)Messages.getMessage("cannotInferTransport", transportURI));
            throw new AxisFault(Messages.getMessage("cannotInferTransport", transportURI));
        }
        if (msgctx.getOptions().getTransportOut() != null) {
            if (msgctx.getOptions().getTransportOut().getSender() == null) {
                log.error((Object)Messages.getMessage("Incomplete transport sender: missing sender!"));
                throw new AxisFault("Incomplete transport sender: missing sender!");
            }
            return msgctx.getOptions().getTransportOut();
        }
        if (epr == null || epr.getAddress() == null) {
            log.error((Object)Messages.getMessage("cannotInferTransportNoAddr"));
            throw new AxisFault(Messages.getMessage("cannotInferTransportNoAddr"));
        }
        String uri = epr.getAddress();
        String transport = Utils.getURIScheme(uri);
        if (transport != null && ac.getTransportOut(transport) != null) {
            return ac.getTransportOut(transport);
        }
        log.error((Object)Messages.getMessage("cannotInferTransport", uri));
        throw new AxisFault(Messages.getMessage("cannotInferTransport", uri));
    }

    public static synchronized TransportInDescription inferInTransport(AxisConfiguration ac, Options options, MessageContext msgCtxt) throws AxisFault {
        String listenerTransportProtocol = options.getTransportInProtocol();
        if (listenerTransportProtocol == null) {
            EndpointReference replyTo = msgCtxt.getReplyTo();
            if (replyTo != null) {
                try {
                    URI uri = new URI(replyTo.getAddress());
                    listenerTransportProtocol = uri.getScheme();
                }
                catch (URISyntaxException uri) {}
            } else if (msgCtxt.getTransportOut() != null) {
                listenerTransportProtocol = msgCtxt.getTransportOut().getName();
            }
        }
        TransportInDescription transportIn = null;
        if (options.isUseSeparateListener() || msgCtxt.getOptions().isUseSeparateListener()) {
            if (listenerTransportProtocol != null && !"".equals(listenerTransportProtocol)) {
                transportIn = ac.getTransportIn(listenerTransportProtocol);
                ListenerManager listenerManager = msgCtxt.getConfigurationContext().getListenerManager();
                if (transportIn == null) {
                    log.error((Object)Messages.getMessage("unknownTransport", listenerTransportProtocol));
                    throw new AxisFault(Messages.getMessage("unknownTransport", listenerTransportProtocol));
                }
                if (!listenerManager.isListenerRunning(transportIn.getName())) {
                    listenerManager.addListener(transportIn, false);
                }
            }
            if (msgCtxt.getAxisService() != null) {
                if (!msgCtxt.isEngaged("addressing")) {
                    log.error((Object)Messages.getMessage("2channelNeedAddressing"));
                    throw new AxisFault(Messages.getMessage("2channelNeedAddressing"));
                }
            } else if (!ac.isEngaged("addressing")) {
                log.error((Object)Messages.getMessage("2channelNeedAddressing"));
                throw new AxisFault(Messages.getMessage("2channelNeedAddressing"));
            }
        }
        return transportIn;
    }
}

