/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.context.AbstractContext;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.inmemory.InMemoryBeanMgr;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryRMSBeanMgr
extends InMemoryBeanMgr<RMSBean>
implements RMSBeanMgr {
    private Lock lock = new ReentrantLock();
    private ConcurrentHashMap<String, String> seqID2csm = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> intSeqID2csm = new ConcurrentHashMap();

    public InMemoryRMSBeanMgr(InMemoryStorageManager mgr, AbstractContext context) {
        super(mgr, context, "CreateSequenceBeanMap");
    }

    @Override
    public boolean insert(RMSBean bean) throws SandeshaStorageException {
        boolean res = false;
        this.lock.lock();
        if (this.intSeqID2csm.get(bean.getInternalSequenceID()) == null && (res = super.insert(bean.getCreateSeqMsgID(), bean))) {
            if (bean.getInternalSequenceID() != null) {
                this.intSeqID2csm.put(bean.getInternalSequenceID(), bean.getCreateSeqMsgID());
            }
            if (bean.getSequenceID() != null) {
                this.seqID2csm.put(bean.getSequenceID(), bean.getCreateSeqMsgID());
            }
        }
        this.lock.unlock();
        return res;
    }

    @Override
    public boolean delete(String msgId) throws SandeshaStorageException {
        RMSBean removed = (RMSBean)super.delete(msgId);
        if (removed != null) {
            this.seqID2csm.remove(removed.getSequenceID());
            this.intSeqID2csm.remove(removed.getInternalSequenceID());
        }
        return removed != null;
    }

    @Override
    public RMSBean retrieve(String msgId) throws SandeshaStorageException {
        return (RMSBean)super.retrieve(msgId);
    }

    @Override
    public boolean update(RMSBean bean) throws SandeshaStorageException {
        boolean result = false;
        result = super.update(bean.getCreateSeqMsgID(), bean);
        if (bean.getInternalSequenceID() != null) {
            this.intSeqID2csm.put(bean.getInternalSequenceID(), bean.getCreateSeqMsgID());
        }
        if (bean.getSequenceID() != null) {
            this.seqID2csm.put(bean.getSequenceID(), bean.getCreateSeqMsgID());
        }
        return result;
    }

    @Override
    public List<RMSBean> find(RMSBean bean) throws SandeshaStorageException {
        return super.find(bean);
    }

    @Override
    public RMSBean findUnique(RMSBean bean) throws SandeshaStorageException {
        return super.findUnique(bean);
    }

    @Override
    public RMSBean retrieveBySequenceID(String seqId) throws SandeshaStorageException {
        String csid = this.seqID2csm.get(seqId);
        RMSBean bean = null;
        if (csid != null) {
            bean = this.retrieve(csid);
        }
        if (bean == null) {
            RMSBean finder = new RMSBean();
            finder.setSequenceID(seqId);
            bean = this.findUnique(finder);
        }
        return bean;
    }

    @Override
    public RMSBean retrieveByInternalSequenceID(String internalSeqId) throws SandeshaStorageException {
        String csid = this.intSeqID2csm.get(internalSeqId);
        RMSBean bean = null;
        if (csid != null) {
            bean = this.retrieve(csid);
        }
        if (bean == null) {
            RMSBean finder = new RMSBean();
            finder.setInternalSequenceID(internalSeqId);
            bean = this.findUnique(finder);
        }
        return bean;
    }
}

