/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark.stream;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.benchmark.stream.AbstractReaderBenchmark;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncReaderBenchmark
extends AbstractReaderBenchmark {
    private static final Logger logger = LoggerFactory.getLogger(AsyncReaderBenchmark.class);

    @Override
    protected void benchmark(Namespace namespace, String logName, StatsLogger statsLogger) {
        DistributedLogManager dlm = null;
        while (null == dlm) {
            try {
                dlm = namespace.openLog(this.streamName);
            }
            catch (IOException ioe) {
                logger.warn("Failed to create dlm for stream {} : ", (Object)this.streamName, (Object)ioe);
            }
            if (null != dlm) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(this.conf.getZKSessionTimeoutMilliseconds());
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted from sleep while creating dlm for stream {} : ", (Object)this.streamName, (Object)e);
            }
        }
        logger.info("Created dlm for stream {}.", (Object)this.streamName);
        OpStatsLogger openReaderStats = statsLogger.getOpStatsLogger("open_reader");
        OpStatsLogger blockingReadStats = statsLogger.getOpStatsLogger("blocking_read");
        Counter readCounter = statsLogger.getCounter("reads");
        AsyncLogReader reader = null;
        DLSN lastDLSN = null;
        Long lastTxId = null;
        block21: while (null == reader) {
            if (null == lastTxId) {
                switch (this.readMode) {
                    case OLDEST: {
                        lastTxId = 0L;
                        lastDLSN = DLSN.InitialDLSN;
                        break;
                    }
                    case LATEST: {
                        lastTxId = Long.MAX_VALUE;
                        try {
                            lastDLSN = dlm.getLastDLSN();
                            break;
                        }
                        catch (IOException ioe) {
                            continue block21;
                        }
                    }
                    case REWIND: {
                        lastTxId = System.currentTimeMillis() - this.rewindMs;
                        lastDLSN = null;
                        break;
                    }
                    case POSITION: {
                        lastTxId = this.fromTxId;
                        lastDLSN = null;
                        break;
                    }
                    default: {
                        logger.warn("Unsupported mode {}", (Object)this.readMode);
                        this.printUsage();
                        System.exit(0);
                    }
                }
                logger.info("Reading from transaction id = {}, dlsn = {}", (Object)lastTxId, (Object)lastDLSN);
            }
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                reader = null == lastDLSN ? (AsyncLogReader)FutureUtils.result((CompletableFuture)dlm.openAsyncLogReader(lastTxId.longValue())) : (AsyncLogReader)FutureUtils.result((CompletableFuture)dlm.openAsyncLogReader(lastDLSN));
                long elapsedMs = stopwatch.elapsed(TimeUnit.MICROSECONDS);
                openReaderStats.registerSuccessfulEvent(elapsedMs, TimeUnit.MICROSECONDS);
                logger.info("It took {} ms to position the reader to transaction id = {}, dlsn = {}", (Object)lastTxId, (Object)lastDLSN);
            }
            catch (Exception ioe) {
                openReaderStats.registerFailedEvent(stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                logger.warn("Failed to create reader for stream {} reading from tx id = {}, dlsn = {}.", new Object[]{this.streamName, lastTxId, lastDLSN});
            }
            if (null == reader) {
                try {
                    TimeUnit.MILLISECONDS.sleep(this.conf.getZKSessionTimeoutMilliseconds());
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted from sleep after reader was reassigned null for stream {} : ", (Object)this.streamName, (Object)e);
                }
                continue;
            }
            stopwatch = Stopwatch.createUnstarted();
            try {
                while (true) {
                    stopwatch.start();
                    List records = (List)FutureUtils.result((CompletableFuture)reader.readBulk(this.batchSize));
                    long elapsedMicros = stopwatch.stop().elapsed(TimeUnit.MICROSECONDS);
                    blockingReadStats.registerSuccessfulEvent(elapsedMicros, TimeUnit.MICROSECONDS);
                    if (!records.isEmpty()) {
                        readCounter.add((long)records.size());
                        LogRecordWithDLSN lastRecord = (LogRecordWithDLSN)records.get(records.size() - 1);
                        lastTxId = lastRecord.getTransactionId();
                        lastDLSN = lastRecord.getDlsn();
                    }
                    stopwatch.reset();
                }
            }
            catch (Exception e) {
                logger.warn("Encountered reading record from stream {} : ", (Object)this.streamName, (Object)e);
                reader = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.conf.getZKSessionTimeoutMilliseconds());
                }
                catch (InterruptedException e2) {
                    logger.warn("Interrupted from sleep while creating reader for stream {} : ", (Object)this.streamName, (Object)e2);
                }
            }
        }
    }
}

