/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.base.Preconditions;
import com.twitter.common.base.ExceptionalCommand;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.util.CommandExecutor;
import com.twitter.common.util.RetryingRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RateLimitedCommandExecutor
implements CommandExecutor {
    private static final Logger LOG = Logger.getLogger(RateLimitedCommandExecutor.class.getName());
    private final BlockingQueue<RetryingRunnable<?>> blockingQueue;

    public RateLimitedCommandExecutor(ScheduledExecutorService taskExecutor, Amount<Long, Time> intervalBetweenRequests, Runnable queueDrainer, BlockingQueue<RetryingRunnable<?>> blockingQueue) {
        Preconditions.checkNotNull((Object)taskExecutor);
        Preconditions.checkNotNull(intervalBetweenRequests);
        Preconditions.checkArgument(((Long)intervalBetweenRequests.as((Unit)Time.MILLISECONDS) > 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)queueDrainer);
        this.blockingQueue = (BlockingQueue)Preconditions.checkNotNull(blockingQueue);
        taskExecutor.scheduleWithFixedDelay(RateLimitedCommandExecutor.getSafeRunner(queueDrainer), 0L, (Long)intervalBetweenRequests.as((Unit)Time.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    private static Runnable getSafeRunner(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (RuntimeException t) {
                    LOG.log(Level.INFO, " error processing task " + runnable);
                }
            }
        };
    }

    @Override
    public <E extends Exception> void execute(String name, ExceptionalCommand<E> task, Class<E> exceptionClass, int numTries, Amount<Long, Time> retryDelay) {
        this.blockingQueue.add(new RetryingRunnable<E>(name, task, exceptionClass, numTries, retryDelay, this));
    }
}

