/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.io.ByteStreams;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.java.CommandLineOptions;
import com.google.googlejavaformat.java.CommandLineOptionsParser;
import com.google.googlejavaformat.java.FormatFileCallable;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.GoogleJavaFormatVersion;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.UsageException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class Main {
    private static final int MAX_THREADS = 20;
    private static final String STDIN_FILENAME = "<stdin>";
    static final String[] VERSION = new String[]{"google-java-format: Version " + GoogleJavaFormatVersion.VERSION};
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private final InputStream inStream;

    public Main(PrintWriter outWriter, PrintWriter errWriter, InputStream inStream) {
        this.outWriter = outWriter;
        this.errWriter = errWriter;
        this.inStream = inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int result;
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        PrintWriter err = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8));
        try {
            Main formatter = new Main(out, err, System.in);
            result = formatter.format(args);
        }
        catch (UsageException e) {
            err.print(e.getMessage());
            result = 0;
        }
        finally {
            err.flush();
            out.flush();
        }
        System.exit(result);
    }

    public int format(String ... args) throws UsageException {
        CommandLineOptions parameters = Main.processArgs(args);
        if (parameters.version()) {
            for (String line : VERSION) {
                this.errWriter.println(line);
            }
            return 0;
        }
        if (parameters.help()) {
            throw new UsageException();
        }
        JavaFormatterOptions options = JavaFormatterOptions.builder().style(parameters.aosp() ? JavaFormatterOptions.Style.AOSP : JavaFormatterOptions.Style.GOOGLE).build();
        if (parameters.stdin()) {
            return this.formatStdin(parameters, options);
        }
        return this.formatFiles(parameters, options);
    }

    private int formatFiles(CommandLineOptions parameters, JavaFormatterOptions options) {
        int numThreads = Math.min(20, parameters.files().size());
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        LinkedHashMap<Path, String> inputs = new LinkedHashMap<Path, String>();
        LinkedHashMap<Path, Future<String>> results = new LinkedHashMap<Path, Future<String>>();
        for (String fileName : parameters.files()) {
            String input;
            if (!fileName.endsWith(".java")) {
                this.errWriter.println("Skipping non-Java file: " + fileName);
                continue;
            }
            Path path = Paths.get(fileName, new String[0]);
            try {
                input = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.errWriter.println(fileName + ": could not read file: " + e.getMessage());
                return 1;
            }
            inputs.put(path, input);
            results.put(path, executorService.submit(new FormatFileCallable(parameters, input, options)));
        }
        boolean allOk = true;
        for (Map.Entry result : results.entrySet()) {
            String formatted;
            try {
                formatted = (String)((Future)result.getValue()).get();
            }
            catch (InterruptedException e) {
                this.errWriter.println(e.getMessage());
                allOk = false;
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof FormatterException) {
                    for (FormatterDiagnostic diagnostic : ((FormatterException)e.getCause()).diagnostics()) {
                        this.errWriter.println(result.getKey() + ":" + diagnostic.toString());
                    }
                } else {
                    this.errWriter.println(result.getKey() + ": error: " + e.getCause().getMessage());
                    e.getCause().printStackTrace(this.errWriter);
                }
                allOk = false;
                continue;
            }
            if (parameters.inPlace()) {
                if (formatted.equals(inputs.get(result.getKey()))) continue;
                try {
                    Files.write((Path)result.getKey(), formatted.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    this.errWriter.println(result.getKey() + ": could not write file: " + e.getMessage());
                    allOk = false;
                }
                continue;
            }
            this.outWriter.write(formatted);
        }
        return allOk ? 0 : 1;
    }

    private int formatStdin(CommandLineOptions parameters, JavaFormatterOptions options) {
        String input;
        try {
            input = new String(ByteStreams.toByteArray((InputStream)this.inStream), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        try {
            String output = new FormatFileCallable(parameters, input, options).call();
            this.outWriter.write(output);
            return 0;
        }
        catch (FormatterException e) {
            for (FormatterDiagnostic diagnostic : e.diagnostics()) {
                this.errWriter.println("<stdin>:" + diagnostic.toString());
            }
            return 1;
        }
    }

    public static CommandLineOptions processArgs(String ... args) throws UsageException {
        CommandLineOptions parameters;
        try {
            parameters = CommandLineOptionsParser.parse(Arrays.asList(args));
        }
        catch (IllegalArgumentException e) {
            throw new UsageException(e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new UsageException(t.getMessage());
        }
        int filesToFormat = parameters.files().size();
        if (parameters.stdin()) {
            ++filesToFormat;
        }
        if (parameters.inPlace() && parameters.files().isEmpty()) {
            throw new UsageException("in-place formatting was requested but no files were provided");
        }
        if (parameters.isSelection() && filesToFormat != 1) {
            throw new UsageException("partial formatting is only support for a single file");
        }
        if (parameters.offsets().size() != parameters.lengths().size()) {
            throw new UsageException(String.format("-offsets and -lengths flags must be provided in matching pairs", new Object[0]));
        }
        if (filesToFormat <= 0 && !parameters.version() && !parameters.help()) {
            throw new UsageException("no files were provided");
        }
        return parameters;
    }
}

