/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.twitter.common.base.Closure;
import com.twitter.common.base.ExceptionalClosure;

public final class Closures {
    private static final Closure<?> NOOP = new Closure<Object>(){

        @Override
        public void execute(Object item) {
        }
    };

    private Closures() {
    }

    public static <T> Function<T, Void> asFunction(final ExceptionalClosure<T, ?> closure) {
        Preconditions.checkNotNull(closure);
        return new Function<T, Void>(){

            public Void apply(T item) {
                try {
                    closure.execute(item);
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
                return null;
            }
        };
    }

    public static <T> Closure<T> combine(Closure<T> ... closures) {
        return Closures.combine(ImmutableList.copyOf((Object[])closures));
    }

    public static <T> Closure<T> combine(Iterable<Closure<T>> closures) {
        Preconditions.checkNotNull(closures);
        Preconditions.checkArgument((boolean)Iterables.all(closures, (Predicate)Predicates.notNull()));
        ImmutableList closuresCopy = ImmutableList.copyOf(closures);
        return new Closure<T>((Iterable)closuresCopy){
            final /* synthetic */ Iterable val$closuresCopy;
            {
                this.val$closuresCopy = iterable;
            }

            @Override
            public void execute(T item) {
                for (Closure closure : this.val$closuresCopy) {
                    closure.execute(item);
                }
            }
        };
    }

    public static <T> Closure<T> filter(final Predicate<T> filter, final Closure<T> closure) {
        Preconditions.checkNotNull(filter);
        Preconditions.checkNotNull(closure);
        return new Closure<T>(){

            @Override
            public void execute(T item) {
                if (filter.apply(item)) {
                    closure.execute(item);
                }
            }
        };
    }

    public static <T> Closure<T> noop() {
        return NOOP;
    }
}

