/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AbstractMemberWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SectionName;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.MemberSummaryWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.PropertyWriter;

public class PropertyWriterImpl
extends AbstractMemberWriter
implements PropertyWriter,
MemberSummaryWriter {
    public PropertyWriterImpl(SubWriterHolderWriter writer, TypeElement typeElement) {
        super(writer, typeElement);
    }

    @Override
    public Content getMemberSummaryHeader(TypeElement typeElement, Content memberSummaryTree) {
        memberSummaryTree.addContent(HtmlConstants.START_OF_PROPERTY_SUMMARY);
        Content memberTree = this.writer.getMemberTreeHeader();
        this.writer.addSummaryHeader(this, typeElement, memberTree);
        return memberTree;
    }

    @Override
    public void addMemberTree(Content memberSummaryTree, Content memberTree) {
        this.writer.addMemberTree(memberSummaryTree, memberTree);
    }

    @Override
    public Content getPropertyDetailsTreeHeader(TypeElement typeElement, Content memberDetailsTree) {
        memberDetailsTree.addContent(HtmlConstants.START_OF_PROPERTY_DETAILS);
        Content propertyDetailsTree = this.writer.getMemberTreeHeader();
        propertyDetailsTree.addContent(this.writer.getMarkerAnchor(SectionName.PROPERTY_DETAIL));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.DETAILS_HEADING, this.writer.propertyDetailsLabel);
        propertyDetailsTree.addContent(heading);
        return propertyDetailsTree;
    }

    @Override
    public Content getPropertyDocTreeHeader(ExecutableElement property, Content propertyDetailsTree) {
        propertyDetailsTree.addContent(this.writer.getMarkerAnchor(this.name(property)));
        Content propertyDocTree = this.writer.getMemberTreeHeader();
        HtmlTree heading = new HtmlTree(HtmlConstants.MEMBER_HEADING);
        ((Content)heading).addContent(this.utils.getPropertyLabel(this.name(property)));
        propertyDocTree.addContent(heading);
        return propertyDocTree;
    }

    @Override
    public Content getSignature(ExecutableElement property) {
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.writer.addAnnotationInfo(property, (Content)pre);
        this.addModifiers(property, pre);
        Content propertylink = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, this.utils.getReturnType(property)));
        ((Content)pre).addContent(propertylink);
        ((Content)pre).addContent(" ");
        if (this.configuration.linksource) {
            StringContent propertyName = new StringContent(this.name(property));
            this.writer.addSrcLink(property, propertyName, pre);
        } else {
            this.addName(this.name(property), pre);
        }
        return pre;
    }

    @Override
    public void addDeprecated(ExecutableElement property, Content propertyDocTree) {
    }

    @Override
    public void addComments(ExecutableElement property, Content propertyDocTree) {
        TypeElement holder = (TypeElement)property.getEnclosingElement();
        if (!this.utils.getBody(property).isEmpty()) {
            if (holder.equals(this.typeElement) || !this.utils.isPublic(holder) || this.utils.isLinkable(holder)) {
                this.writer.addInlineComment(property, propertyDocTree);
            } else {
                Content link = this.writer.getDocLink(LinkInfoImpl.Kind.PROPERTY_COPY, holder, (Element)property, this.utils.isIncluded(holder) ? holder.getSimpleName() : holder.getQualifiedName(), false);
                HtmlTree codeLink = HtmlTree.CODE(link);
                HtmlTree descfrmLabel = HtmlTree.SPAN(HtmlStyle.descfrmTypeLabel, this.utils.isClass(holder) ? this.writer.descfrmClassLabel : this.writer.descfrmInterfaceLabel);
                ((Content)descfrmLabel).addContent(this.writer.getSpace());
                ((Content)descfrmLabel).addContent(codeLink);
                propertyDocTree.addContent(HtmlTree.DIV(HtmlStyle.block, descfrmLabel));
                this.writer.addInlineComment(property, propertyDocTree);
            }
        }
    }

    @Override
    public void addTags(ExecutableElement property, Content propertyDocTree) {
        this.writer.addTagsInfo(property, propertyDocTree);
    }

    @Override
    public Content getPropertyDetails(Content propertyDetailsTree) {
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            HtmlTree htmlTree = HtmlTree.SECTION(this.getMemberTree(propertyDetailsTree));
            return htmlTree;
        }
        return this.getMemberTree(propertyDetailsTree);
    }

    @Override
    public Content getPropertyDoc(Content propertyDocTree, boolean isLastContent) {
        return this.getMemberTree(propertyDocTree, isLastContent);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void addSummaryLabel(Content memberTree) {
        HtmlTree label = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, this.writer.getResource("doclet.Property_Summary"));
        memberTree.addContent(label);
    }

    @Override
    public String getTableSummary() {
        return this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Property_Summary"), this.configuration.getText("doclet.properties"));
    }

    @Override
    public Content getCaption() {
        return this.configuration.getResource("doclet.Properties");
    }

    @Override
    public List<String> getSummaryTableHeader(Element member) {
        List<String> header = Arrays.asList(this.configuration.getText("doclet.Type"), this.configuration.getText("doclet.0_and_1", this.configuration.getText("doclet.Property"), this.configuration.getText("doclet.Description")));
        return header;
    }

    @Override
    public void addSummaryAnchor(TypeElement typeElement, Content memberTree) {
        memberTree.addContent(this.writer.getMarkerAnchor(SectionName.PROPERTY_SUMMARY));
    }

    @Override
    public void addInheritedSummaryAnchor(TypeElement typeElement, Content inheritedTree) {
        inheritedTree.addContent(this.writer.getMarkerAnchor(SectionName.PROPERTIES_INHERITANCE, this.configuration.getClassName(typeElement)));
    }

    @Override
    public void addInheritedSummaryLabel(TypeElement typeElement, Content inheritedTree) {
        Content classLink = this.writer.getPreQualifiedClassLink(LinkInfoImpl.Kind.MEMBER, typeElement, false);
        StringContent label = new StringContent(this.utils.isClass(typeElement) ? this.configuration.getText("doclet.Properties_Inherited_From_Class") : this.configuration.getText("doclet.Properties_Inherited_From_Interface"));
        HtmlTree labelHeading = HtmlTree.HEADING(HtmlConstants.INHERITED_SUMMARY_HEADING, label);
        ((Content)labelHeading).addContent(this.writer.getSpace());
        ((Content)labelHeading).addContent(classLink);
        inheritedTree.addContent(labelHeading);
    }

    @Override
    protected void addSummaryLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element member, Content tdSummary) {
        HtmlTree memberLink = HtmlTree.SPAN(HtmlStyle.memberNameLink, this.writer.getDocLink(context, typeElement, member, this.utils.getPropertyLabel(this.name(member)), false, true));
        HtmlTree code = HtmlTree.CODE(memberLink);
        tdSummary.addContent(code);
    }

    @Override
    protected void addInheritedSummaryLink(TypeElement typeElement, Element member, Content linksTree) {
        String mname = this.name(member);
        Content content = this.writer.getDocLink(LinkInfoImpl.Kind.MEMBER, typeElement, member, this.utils.isProperty(mname) ? this.utils.getPropertyName(mname) : mname, false, true);
        linksTree.addContent(content);
    }

    @Override
    protected void addSummaryType(Element member, Content tdSummaryType) {
        this.addModifierAndType(member, this.utils.getReturnType((ExecutableElement)member), tdSummaryType);
    }

    @Override
    protected Content getDeprecatedLink(Element member) {
        return this.writer.getDocLink(LinkInfoImpl.Kind.MEMBER, member, this.utils.getFullyQualifiedName(member));
    }

    @Override
    protected Content getNavSummaryLink(TypeElement typeElement, boolean link) {
        if (link) {
            if (typeElement == null) {
                return this.writer.getHyperLink(SectionName.PROPERTY_SUMMARY, this.writer.getResource("doclet.navProperty"));
            }
            return this.writer.getHyperLink(SectionName.PROPERTIES_INHERITANCE, this.configuration.getClassName(typeElement), this.writer.getResource("doclet.navProperty"));
        }
        return this.writer.getResource("doclet.navProperty");
    }

    @Override
    protected void addNavDetailLink(boolean link, Content liNav) {
        if (link) {
            liNav.addContent(this.writer.getHyperLink(SectionName.PROPERTY_DETAIL, this.writer.getResource("doclet.navProperty")));
        } else {
            liNav.addContent(this.writer.getResource("doclet.navProperty"));
        }
    }
}

