/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogSegmentWriter;
import org.apache.distributedlog.BKLogWriteHandler;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.common.util.PermitManager;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.AlreadyClosedException;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.io.Abortable;
import org.apache.distributedlog.io.Abortables;
import org.apache.distributedlog.io.AsyncAbortable;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BKAbstractLogWriter
implements Closeable,
AsyncCloseable,
Abortable,
AsyncAbortable {
    static final Logger LOG = LoggerFactory.getLogger(BKAbstractLogWriter.class);
    protected final DistributedLogConfiguration conf;
    private final DynamicDistributedLogConfiguration dynConf;
    protected final BKDistributedLogManager bkDistributedLogManager;
    private CompletableFuture<Void> closePromise = null;
    private volatile boolean forceRolling = false;
    private boolean forceRecovery = false;
    private CompletableFuture<List<LogSegmentMetadata>> lastTruncationAttempt = null;
    @VisibleForTesting
    private Long minTimestampToKeepOverride = null;
    protected BKLogSegmentWriter segmentWriter = null;
    protected CompletableFuture<BKLogSegmentWriter> segmentWriterFuture = null;
    protected BKLogSegmentWriter allocatedSegmentWriter = null;
    protected BKLogWriteHandler writeHandler = null;

    BKAbstractLogWriter(DistributedLogConfiguration conf, DynamicDistributedLogConfiguration dynConf, BKDistributedLogManager bkdlm) {
        this.conf = conf;
        this.dynConf = dynConf;
        this.bkDistributedLogManager = bkdlm;
        LOG.debug("Initial retention period for {} : {}", (Object)bkdlm.getStreamName(), (Object)TimeUnit.MILLISECONDS.convert(dynConf.getRetentionPeriodHours(), TimeUnit.HOURS));
    }

    protected synchronized BKLogWriteHandler getCachedWriteHandler() {
        return this.writeHandler;
    }

    protected BKLogWriteHandler getWriteHandler() throws IOException {
        BKLogWriteHandler writeHandler = this.createAndCacheWriteHandler();
        writeHandler.checkMetadataException();
        return writeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BKLogWriteHandler createAndCacheWriteHandler() throws IOException {
        BKAbstractLogWriter bKAbstractLogWriter = this;
        synchronized (bKAbstractLogWriter) {
            if (this.writeHandler != null) {
                return this.writeHandler;
            }
        }
        BKLogWriteHandler newHandler = Utils.ioResult(this.bkDistributedLogManager.asyncCreateWriteHandler(false));
        boolean success = false;
        try {
            BKAbstractLogWriter bKAbstractLogWriter2 = this;
            synchronized (bKAbstractLogWriter2) {
                if (this.writeHandler == null) {
                    this.writeHandler = newHandler;
                    success = true;
                }
                BKLogWriteHandler bKLogWriteHandler = this.writeHandler;
                return bKLogWriteHandler;
            }
        }
        finally {
            if (!success) {
                newHandler.asyncAbort();
            }
        }
    }

    protected synchronized BKLogSegmentWriter getCachedLogWriter() {
        return this.segmentWriter;
    }

    protected synchronized CompletableFuture<BKLogSegmentWriter> getCachedLogWriterFuture() {
        return this.segmentWriterFuture;
    }

    protected synchronized void cacheLogWriter(BKLogSegmentWriter logWriter) {
        this.segmentWriter = logWriter;
        this.segmentWriterFuture = FutureUtils.value((Object)logWriter);
    }

    protected synchronized BKLogSegmentWriter removeCachedLogWriter() {
        try {
            BKLogSegmentWriter bKLogSegmentWriter = this.segmentWriter;
            return bKLogSegmentWriter;
        }
        finally {
            this.segmentWriter = null;
            this.segmentWriterFuture = null;
        }
    }

    protected synchronized BKLogSegmentWriter getAllocatedLogWriter() {
        return this.allocatedSegmentWriter;
    }

    protected synchronized void cacheAllocatedLogWriter(BKLogSegmentWriter logWriter) {
        this.allocatedSegmentWriter = logWriter;
    }

    protected synchronized BKLogSegmentWriter removeAllocatedLogWriter() {
        try {
            BKLogSegmentWriter bKLogSegmentWriter = this.allocatedSegmentWriter;
            return bKLogSegmentWriter;
        }
        finally {
            this.allocatedSegmentWriter = null;
        }
    }

    private CompletableFuture<Void> asyncCloseAndComplete(boolean shouldThrow) {
        BKLogSegmentWriter segmentWriter = this.getCachedLogWriter();
        BKLogWriteHandler writeHandler = this.getCachedWriteHandler();
        if (null != segmentWriter && null != writeHandler) {
            this.cancelTruncation();
            CompletableFuture<Void> completePromise = new CompletableFuture<Void>();
            this.asyncCloseAndComplete(segmentWriter, writeHandler, completePromise, shouldThrow);
            return completePromise;
        }
        return this.closeNoThrow();
    }

    private void asyncCloseAndComplete(BKLogSegmentWriter segmentWriter, BKLogWriteHandler writeHandler, final CompletableFuture<Void> completePromise, final boolean shouldThrow) {
        writeHandler.completeAndCloseLogSegment(segmentWriter).whenComplete((BiConsumer)new FutureEventListener<LogSegmentMetadata>(){

            public void onSuccess(LogSegmentMetadata segment) {
                BKAbstractLogWriter.this.removeCachedLogWriter();
                this.complete(null);
            }

            public void onFailure(Throwable cause) {
                LOG.error("Completing Log segments encountered exception", cause);
                this.complete(cause);
            }

            private void complete(Throwable cause) {
                FutureUtils.ensure(BKAbstractLogWriter.this.closeNoThrow(), () -> {
                    if (null != cause && shouldThrow) {
                        FutureUtils.completeExceptionally((CompletableFuture)completePromise, (Throwable)cause);
                    } else {
                        FutureUtils.complete((CompletableFuture)completePromise, null);
                    }
                });
            }
        });
    }

    @VisibleForTesting
    void closeAndComplete() throws IOException {
        Utils.ioResult(this.asyncCloseAndComplete(true));
    }

    protected CompletableFuture<Void> asyncCloseAndComplete() {
        return this.asyncCloseAndComplete(true);
    }

    @Override
    public void close() throws IOException {
        Utils.ioResult(this.asyncClose());
    }

    public CompletableFuture<Void> asyncClose() {
        return this.asyncCloseAndComplete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> closeNoThrow() {
        CompletableFuture<Void> closeFuture;
        BKAbstractLogWriter bKAbstractLogWriter = this;
        synchronized (bKAbstractLogWriter) {
            if (null != this.closePromise) {
                return this.closePromise;
            }
            this.closePromise = new CompletableFuture<Void>();
            closeFuture = this.closePromise;
        }
        this.cancelTruncation();
        FutureUtils.proxyTo(Utils.closeSequence((ExecutorService)this.bkDistributedLogManager.getScheduler(), true, this.getCachedLogWriter(), this.getAllocatedLogWriter(), this.getCachedWriteHandler()), closeFuture);
        return closeFuture;
    }

    public void abort() throws IOException {
        Utils.ioResult(this.asyncAbort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> asyncAbort() {
        CompletableFuture<Void> closeFuture;
        BKAbstractLogWriter bKAbstractLogWriter = this;
        synchronized (bKAbstractLogWriter) {
            if (null != this.closePromise) {
                return this.closePromise;
            }
            this.closePromise = new CompletableFuture<Void>();
            closeFuture = this.closePromise;
        }
        this.cancelTruncation();
        FutureUtils.proxyTo((CompletableFuture)Abortables.abortSequence((ExecutorService)this.bkDistributedLogManager.getScheduler(), (AsyncAbortable[])new AsyncAbortable[]{this.getCachedLogWriter(), this.getAllocatedLogWriter(), this.getCachedWriteHandler()}), closeFuture);
        return closeFuture;
    }

    protected BKLogSegmentWriter getLedgerWriter(long startTxId, boolean allowMaxTxID) throws IOException {
        CompletableFuture<BKLogSegmentWriter> logSegmentWriterFuture = this.asyncGetLedgerWriter(true);
        BKLogSegmentWriter logSegmentWriter = null;
        if (null != logSegmentWriterFuture) {
            logSegmentWriter = Utils.ioResult(logSegmentWriterFuture);
        }
        if (null == logSegmentWriter || this.shouldStartNewSegment(logSegmentWriter) || this.forceRolling) {
            logSegmentWriter = Utils.ioResult(this.rollLogSegmentIfNecessary(logSegmentWriter, startTxId, true, allowMaxTxID));
        }
        return logSegmentWriter;
    }

    protected synchronized CompletableFuture<BKLogSegmentWriter> asyncGetLedgerWriter(boolean resetOnError) {
        final BKLogSegmentWriter ledgerWriter = this.getCachedLogWriter();
        CompletableFuture<BKLogSegmentWriter> ledgerWriterFuture = this.getCachedLogWriterFuture();
        if (null == ledgerWriterFuture || null == ledgerWriter) {
            return null;
        }
        if ((ledgerWriter.isLogSegmentInError() || this.forceRecovery) && resetOnError) {
            CompletableFuture<Void> closeFuture = ledgerWriter.isLogSegmentInError() ? ledgerWriter.asyncAbort() : ledgerWriter.asyncClose();
            return closeFuture.thenCompose(new Function<Void, CompletionStage<BKLogSegmentWriter>>(){

                @Override
                public CompletableFuture<BKLogSegmentWriter> apply(Void result) {
                    BKLogWriteHandler writeHandler;
                    BKAbstractLogWriter.this.removeCachedLogWriter();
                    if (ledgerWriter.isLogSegmentInError()) {
                        return FutureUtils.value(null);
                    }
                    try {
                        writeHandler = BKAbstractLogWriter.this.getWriteHandler();
                    }
                    catch (IOException e) {
                        return FutureUtils.exception((Throwable)e);
                    }
                    if (null != writeHandler && BKAbstractLogWriter.this.forceRecovery) {
                        return writeHandler.completeAndCloseLogSegment(ledgerWriter).thenApply(new Function<LogSegmentMetadata, BKLogSegmentWriter>(){

                            @Override
                            public BKLogSegmentWriter apply(LogSegmentMetadata completedLogSegment) {
                                return null;
                            }
                        });
                    }
                    return FutureUtils.value(null);
                }
            });
        }
        return ledgerWriterFuture;
    }

    boolean shouldStartNewSegment(BKLogSegmentWriter ledgerWriter) throws IOException {
        BKLogWriteHandler writeHandler = this.getWriteHandler();
        return null == ledgerWriter || writeHandler.shouldStartNewSegment(ledgerWriter) || this.forceRolling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateLogSegmentsIfNecessary(BKLogWriteHandler writeHandler) {
        boolean truncationEnabled = false;
        long minTimestampToKeep = 0L;
        long retentionPeriodInMillis = TimeUnit.MILLISECONDS.convert(this.dynConf.getRetentionPeriodHours(), TimeUnit.HOURS);
        if (retentionPeriodInMillis > 0L) {
            minTimestampToKeep = Utils.nowInMillis() - retentionPeriodInMillis;
            truncationEnabled = true;
        }
        if (null != this.minTimestampToKeepOverride) {
            minTimestampToKeep = this.minTimestampToKeepOverride;
            truncationEnabled = true;
        }
        BKAbstractLogWriter bKAbstractLogWriter = this;
        synchronized (bKAbstractLogWriter) {
            if (truncationEnabled && (this.lastTruncationAttempt == null || this.lastTruncationAttempt.isDone())) {
                this.lastTruncationAttempt = writeHandler.purgeLogSegmentsOlderThanTimestamp(minTimestampToKeep);
            }
        }
    }

    private CompletableFuture<BKLogSegmentWriter> asyncStartNewLogSegment(BKLogWriteHandler writeHandler, long startTxId, boolean allowMaxTxID) {
        return writeHandler.recoverIncompleteLogSegments().thenCompose(lastTxId -> writeHandler.asyncStartLogSegment(startTxId, false, allowMaxTxID).thenApply(newSegmentWriter -> {
            this.cacheLogWriter((BKLogSegmentWriter)newSegmentWriter);
            return newSegmentWriter;
        }));
    }

    private CompletableFuture<BKLogSegmentWriter> closeOldLogSegmentAndStartNewOneWithPermit(BKLogSegmentWriter oldSegmentWriter, BKLogWriteHandler writeHandler, long startTxId, boolean bestEffort, boolean allowMaxTxID) {
        PermitManager.Permit switchPermit = this.bkDistributedLogManager.getLogSegmentRollingPermitManager().acquirePermit();
        if (switchPermit.isAllowed()) {
            return FutureUtils.ensure((CompletableFuture)FutureUtils.rescue(this.closeOldLogSegmentAndStartNewOne(oldSegmentWriter, writeHandler, startTxId, bestEffort, allowMaxTxID), cause -> {
                ZKException zke;
                if (cause instanceof LockingException) {
                    LOG.warn("We lost lock during completeAndClose log segment for {}. Disable ledger rolling until it is recovered : ", (Object)writeHandler.getFullyQualifiedName(), cause);
                    this.bkDistributedLogManager.getLogSegmentRollingPermitManager().disallowObtainPermits(switchPermit);
                    return FutureUtils.value((Object)oldSegmentWriter);
                }
                if (cause instanceof ZKException && ZKException.isRetryableZKException(zke = (ZKException)((Object)((Object)cause)))) {
                    LOG.warn("Encountered zookeeper connection issues during completeAndClose log segment for {}. Disable ledger rolling until it is recovered : {}", (Object)writeHandler.getFullyQualifiedName(), (Object)zke.getKeeperExceptionCode());
                    this.bkDistributedLogManager.getLogSegmentRollingPermitManager().disallowObtainPermits(switchPermit);
                    return FutureUtils.value((Object)oldSegmentWriter);
                }
                return FutureUtils.exception((Throwable)cause);
            }), () -> this.bkDistributedLogManager.getLogSegmentRollingPermitManager().releasePermit(switchPermit));
        }
        this.bkDistributedLogManager.getLogSegmentRollingPermitManager().releasePermit(switchPermit);
        return FutureUtils.value((Object)oldSegmentWriter);
    }

    private CompletableFuture<BKLogSegmentWriter> closeOldLogSegmentAndStartNewOne(final BKLogSegmentWriter oldSegmentWriter, final BKLogWriteHandler writeHandler, final long startTxId, final boolean bestEffort, boolean allowMaxTxID) {
        BKLogSegmentWriter newSegmentWriter = this.getAllocatedLogWriter();
        if (null == newSegmentWriter) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Allocating a new log segment from {} for {}.", (Object)startTxId, (Object)writeHandler.getFullyQualifiedName());
            }
            return writeHandler.asyncStartLogSegment(startTxId, bestEffort, allowMaxTxID).thenCompose(new Function<BKLogSegmentWriter, CompletableFuture<BKLogSegmentWriter>>(){

                @Override
                public CompletableFuture<BKLogSegmentWriter> apply(BKLogSegmentWriter newSegmentWriter) {
                    if (null == newSegmentWriter) {
                        if (bestEffort) {
                            return FutureUtils.value((Object)oldSegmentWriter);
                        }
                        return FutureUtils.exception((Throwable)new UnexpectedException("StartLogSegment returns null for bestEffort rolling"));
                    }
                    BKAbstractLogWriter.this.cacheAllocatedLogWriter(newSegmentWriter);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Allocated a new log segment from {} for {}.", (Object)startTxId, (Object)writeHandler.getFullyQualifiedName());
                    }
                    return BKAbstractLogWriter.this.completeOldSegmentAndCacheNewLogSegmentWriter(oldSegmentWriter, newSegmentWriter);
                }
            });
        }
        return this.completeOldSegmentAndCacheNewLogSegmentWriter(oldSegmentWriter, newSegmentWriter);
    }

    private CompletableFuture<BKLogSegmentWriter> completeOldSegmentAndCacheNewLogSegmentWriter(BKLogSegmentWriter oldSegmentWriter, final BKLogSegmentWriter newSegmentWriter) {
        final CompletableFuture<BKLogSegmentWriter> completePromise = new CompletableFuture<BKLogSegmentWriter>();
        this.writeHandler.completeAndCloseLogSegment(oldSegmentWriter).whenComplete((BiConsumer)new FutureEventListener<LogSegmentMetadata>(){

            public void onSuccess(LogSegmentMetadata value) {
                BKAbstractLogWriter.this.cacheLogWriter(newSegmentWriter);
                BKAbstractLogWriter.this.removeAllocatedLogWriter();
                FutureUtils.complete((CompletableFuture)completePromise, (Object)newSegmentWriter);
            }

            public void onFailure(Throwable cause) {
                FutureUtils.completeExceptionally((CompletableFuture)completePromise, (Throwable)cause);
            }
        });
        return completePromise;
    }

    protected synchronized CompletableFuture<BKLogSegmentWriter> rollLogSegmentIfNecessary(final BKLogSegmentWriter segmentWriter, long startTxId, boolean bestEffort, boolean allowMaxTxID) {
        BKLogWriteHandler writeHandler;
        try {
            writeHandler = this.getWriteHandler();
        }
        catch (IOException e) {
            return FutureUtils.exception((Throwable)e);
        }
        CompletableFuture<BKLogSegmentWriter> rollPromise = null != segmentWriter && (writeHandler.shouldStartNewSegment(segmentWriter) || this.forceRolling) ? this.closeOldLogSegmentAndStartNewOneWithPermit(segmentWriter, writeHandler, startTxId, bestEffort, allowMaxTxID) : (null == segmentWriter ? this.asyncStartNewLogSegment(writeHandler, startTxId, allowMaxTxID) : FutureUtils.value((Object)segmentWriter));
        return rollPromise.thenApply(new Function<BKLogSegmentWriter, BKLogSegmentWriter>(){

            @Override
            public BKLogSegmentWriter apply(BKLogSegmentWriter newSegmentWriter) {
                if (segmentWriter == newSegmentWriter) {
                    return newSegmentWriter;
                }
                BKAbstractLogWriter.this.truncateLogSegmentsIfNecessary(writeHandler);
                return newSegmentWriter;
            }
        });
    }

    protected synchronized void checkClosedOrInError(String operation) throws AlreadyClosedException {
        if (null != this.closePromise) {
            LOG.error("Executing " + operation + " on already closed Log Writer");
            throw new AlreadyClosedException("Executing " + operation + " on already closed Log Writer");
        }
    }

    @VisibleForTesting
    public void setForceRolling(boolean forceRolling) {
        this.forceRolling = forceRolling;
    }

    @VisibleForTesting
    public synchronized void overRideMinTimeStampToKeep(Long minTimestampToKeepOverride) {
        this.minTimestampToKeepOverride = minTimestampToKeepOverride;
    }

    protected synchronized void cancelTruncation() {
        if (null != this.lastTruncationAttempt) {
            this.lastTruncationAttempt.cancel(true);
            this.lastTruncationAttempt = null;
        }
    }

    @VisibleForTesting
    public synchronized void setForceRecovery(boolean forceRecovery) {
        this.forceRecovery = forceRecovery;
    }
}

