/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Preconditions;
import com.twitter.common.stats.CounterMap;

public class Entropy<T> {
    private final CounterMap<T> counts = new CounterMap();
    private int total = 0;

    private static double Log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public Entropy(Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        for (T t : iterable) {
            this.counts.incrementAndGet(t);
            ++this.total;
        }
    }

    public double entropy() {
        double d = 0.0;
        for (int n : this.counts.values()) {
            double d2 = (double)n / (double)this.total;
            d -= d2 * Entropy.Log2(d2);
        }
        return d;
    }

    public double perplexity() {
        return Math.pow(2.0, this.entropy());
    }
}

