/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Arg;
import com.twitter.common.args.ArgumentInfo;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.Positional;
import com.twitter.common.args.TypeUtil;
import com.twitter.common.args.apt.Configuration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class PositionalInfo<T>
extends ArgumentInfo<List<T>> {
    private final TypeToken<T> elementType;

    static PositionalInfo<?> createFromField(Field field) {
        return PositionalInfo.createFromField(field, null);
    }

    static PositionalInfo<?> createFromField(Field field, @Nullable Object instance) {
        Preconditions.checkNotNull((Object)field);
        Positional positional = field.getAnnotation(Positional.class);
        if (positional == null) {
            throw new Configuration.ConfigurationException("No @Positional Arg annotation for field " + field, new Object[0]);
        }
        Preconditions.checkArgument((TypeUtil.getRawType(TypeUtil.getTypeParam(field)) == List.class ? 1 : 0) != 0, (Object)"Field is annotated for positional parsing but is not of Arg<List<?>> type");
        Type nestedType = TypeUtil.extractTypeToken(TypeUtil.getTypeParam(field));
        PositionalInfo positionalInfo = new PositionalInfo(field.getDeclaringClass().getCanonicalName() + "." + field.getName(), "[positional args]", positional.help(), ArgumentInfo.getArgForField(field, Optional.fromNullable((Object)instance)), TypeUtil.getTypeParamTypeToken(field), TypeToken.of((Type)nestedType), Arrays.asList(field.getAnnotations()), positional.parser());
        return positionalInfo;
    }

    private PositionalInfo(String canonicalName, String name, String help, Arg<List<T>> arg, TypeToken<List<T>> type, TypeToken<T> elementType, List<Annotation> verifierAnnotations, @Nullable Class<? extends Parser<? extends List<T>>> parser) {
        super(canonicalName, name, help, false, arg, type, verifierAnnotations, parser);
        this.elementType = elementType;
    }

    void load(final ParserOracle parserOracle, List<String> positionalArgs) {
        final Parser parser = parserOracle.get(this.elementType);
        ArrayList assignmentValue = Lists.newArrayList((Iterable)Iterables.transform(positionalArgs, (Function)new Function<String, T>(){

            public T apply(String argValue) {
                return parser.parse(parserOracle, PositionalInfo.this.elementType.getType(), argValue);
            }
        }));
        this.setValue(assignmentValue);
    }
}

