/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerHandleAdv;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerCreateOp
implements BookkeeperInternalCallbacks.GenericCallback<Void> {
    static final Logger LOG = LoggerFactory.getLogger(LedgerCreateOp.class);
    AsyncCallback.CreateCallback cb;
    LedgerMetadata metadata;
    LedgerHandle lh;
    Long ledgerId = -1L;
    Object ctx;
    byte[] passwd;
    BookKeeper bk;
    BookKeeper.DigestType digestType;
    long startTime;
    OpStatsLogger createOpLogger;
    boolean adv = false;
    boolean generateLedgerId = true;

    LedgerCreateOp(BookKeeper bk, int ensembleSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx, Map<String, byte[]> customMetadata) {
        this.bk = bk;
        this.metadata = new LedgerMetadata(ensembleSize, writeQuorumSize, ackQuorumSize, digestType, passwd, customMetadata);
        this.digestType = digestType;
        this.passwd = passwd;
        this.cb = cb;
        this.ctx = ctx;
        this.startTime = MathUtils.nowInNano();
        this.createOpLogger = bk.getCreateOpLogger();
    }

    public void initiate() {
        ArrayList<BookieSocketAddress> ensemble;
        try {
            ensemble = this.bk.bookieWatcher.newEnsemble(this.metadata.getEnsembleSize(), this.metadata.getWriteQuorumSize(), this.metadata.getAckQuorumSize(), this.metadata.getCustomMetadata());
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            LOG.error("Not enough bookies to create ledger");
            this.createComplete(e.getCode(), null);
            return;
        }
        this.metadata.addEnsemble(0L, ensemble);
        if (this.generateLedgerId) {
            this.generateLedgerIdAndCreateLedger();
        } else {
            this.bk.getLedgerManager().createLedgerMetadata(this.ledgerId, this.metadata, this);
        }
    }

    void generateLedgerIdAndCreateLedger() {
        LedgerIdGenerator ledgerIdGenerator = this.bk.getLedgerIdGenerator();
        ledgerIdGenerator.generateLedgerId(new BookkeeperInternalCallbacks.GenericCallback<Long>(){

            @Override
            public void operationComplete(int rc, Long ledgerId) {
                if (0 != rc) {
                    LedgerCreateOp.this.createComplete(rc, null);
                    return;
                }
                LedgerCreateOp.this.ledgerId = ledgerId;
                LedgerCreateOp.this.bk.getLedgerManager().createLedgerMetadata(ledgerId, LedgerCreateOp.this.metadata, LedgerCreateOp.this);
            }
        });
    }

    public void initiateAdv(long ledgerId) {
        this.adv = true;
        this.ledgerId = ledgerId;
        if (this.ledgerId != -1L) {
            this.generateLedgerId = false;
        }
        this.initiate();
    }

    @Override
    public void operationComplete(int rc, Void result) {
        if (this.generateLedgerId && -20 == rc) {
            this.generateLedgerIdAndCreateLedger();
            return;
        }
        if (0 != rc) {
            this.createComplete(rc, null);
            return;
        }
        try {
            this.lh = this.adv ? new LedgerHandleAdv(this.bk, this.ledgerId, this.metadata, this.digestType, this.passwd) : new LedgerHandle(this.bk, this.ledgerId, this.metadata, this.digestType, this.passwd);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Security exception while creating ledger: " + this.ledgerId, (Throwable)e);
            this.createComplete(-4, null);
            return;
        }
        catch (NumberFormatException e) {
            LOG.error("Incorrectly entered parameter throttle: " + this.bk.getConf().getThrottleValue(), (Throwable)e);
            this.createComplete(-14, null);
            return;
        }
        this.createComplete(0, this.lh);
    }

    private void createComplete(int rc, LedgerHandle lh) {
        if (0 != rc) {
            this.createOpLogger.registerFailedEvent(MathUtils.elapsedNanos(this.startTime), TimeUnit.NANOSECONDS);
        } else {
            this.createOpLogger.registerSuccessfulEvent(MathUtils.elapsedNanos(this.startTime), TimeUnit.NANOSECONDS);
        }
        this.cb.createComplete(rc, lh, this.ctx);
    }
}

