/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.client.BKException;

class SynchCallbackUtils {
    SynchCallbackUtils() {
    }

    public static <T> T waitForResult(CompletableFuture<T> future) throws InterruptedException, BKException {
        try {
            return future.get();
        }
        catch (ExecutionException err) {
            if (err.getCause() instanceof BKException) {
                throw (BKException)err.getCause();
            }
            BKException unexpectedConditionException = BKException.create(-999);
            unexpectedConditionException.initCause(err.getCause());
            throw unexpectedConditionException;
        }
    }

    public static <T> void finish(int rc, T result, CompletableFuture<T> future) {
        if (rc != 0) {
            future.completeExceptionally(BKException.create(rc).fillInStackTrace());
        } else {
            future.complete(result);
        }
    }
}

